/*
 * Decompiled with CFR 0.152.
 */
package net.seikasu.improved_multishot.advancement;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.seikasu.improved_multishot.ImprovedMultishot;
import net.seikasu.improved_multishot.advancement.MultishotTripleHitTrigger;

@Mod.EventBusSubscriber(modid="improved_multishot")
public class MultishotEventHandler {
    private static final Map<UUID, Map<UUID, HitData>> hitCounts = new HashMap<UUID, Map<UUID, HitData>>();
    private static long currentTick = 0L;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++currentTick;
        }
        if (currentTick % 100L == 0L) {
            Iterator<Map.Entry<UUID, Map<UUID, HitData>>> it = hitCounts.entrySet().iterator();
            while (it.hasNext()) {
                Map<UUID, HitData> inner = it.next().getValue();
                inner.entrySet().removeIf(e -> currentTick - ((HitData)e.getValue()).tickTime > 100L);
                if (!inner.isEmpty()) continue;
                it.remove();
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        Entity entity = arrow.m_19749_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityResult = (EntityHitResult)hitResult;
        Entity entity2 = entityResult.m_82443_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity2;
        ItemStack crossbow = ItemStack.f_41583_;
        if (player.m_21205_().m_41720_() instanceof CrossbowItem) {
            crossbow = player.m_21205_();
        } else if (player.m_21206_().m_41720_() instanceof CrossbowItem) {
            crossbow = player.m_21206_();
        }
        if (crossbow.m_41619_()) {
            return;
        }
        if (crossbow.getEnchantmentLevel(Enchantments.f_44959_) < 1) {
            return;
        }
        Map byPlayer = hitCounts.computeIfAbsent(target.m_20148_(), k -> new HashMap());
        HitData data = byPlayer.computeIfAbsent(player.m_20148_(), k -> new HitData());
        if (currentTick - data.tickTime > 3L) {
            data.count = 0;
        }
        ++data.count;
        data.tickTime = currentTick;
        if (data.count >= 3) {
            MultishotTripleHitTrigger trigger = ImprovedMultishot.MULTISHOT_TRIPLE_HIT;
            trigger.trigger(player, (Entity)target);
            data.count = 0;
        }
    }

    private static class HitData {
        int count;
        long tickTime;

        private HitData() {
        }
    }
}

