/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarytabs.api.tabs_menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ScreenEvent;
import sfiomn.legendarytabs.LegendaryTabs;
import sfiomn.legendarytabs.api.tabs_menu.TabBase;
import sfiomn.legendarytabs.client.screens.NextTabsButton;
import sfiomn.legendarytabs.client.screens.TabButton;
import sfiomn.legendarytabs.config.Config;

public class TabsMenu {
    private static final Map<Class<? extends Screen>, ScreenInfo> tabsScreens = new HashMap<Class<? extends Screen>, ScreenInfo>();
    private static int leftScreenPos;
    private static int topScreenPos;
    private static int startTabIndex;
    private static int currentTabsCount;
    private static List<TabBase> enabledTabs;

    private TabsMenu() {
    }

    public static void updateButtonsPosition(Screen screen, int leftScreenPos, int topScreenPos) {
        if (TabsMenu.leftScreenPos != leftScreenPos || TabsMenu.topScreenPos != topScreenPos) {
            TabsMenu.leftScreenPos = leftScreenPos;
            TabsMenu.topScreenPos = topScreenPos;
            for (GuiEventListener button : screen.m_6702_()) {
                Button tabButton;
                if (button instanceof TabButton) {
                    tabButton = (TabButton)button;
                    tabButton.updatePosition(TabsMenu.leftScreenPos, TabsMenu.topScreenPos);
                }
                if (!(button instanceof NextTabsButton)) continue;
                tabButton = (NextTabsButton)button;
                tabButton.updatePosition(TabsMenu.leftScreenPos, TabsMenu.topScreenPos);
            }
        }
    }

    public static void addTabToScreen(TabBase newTab, Class<? extends Screen> screen, Function<Player, Integer> screenWidth, Function<Player, Integer> screenHeight, int priority) {
        if (tabsScreens.containsKey(screen)) {
            tabsScreens.get(screen).addTab(priority, newTab);
        } else {
            ScreenInfo screenInfo = new ScreenInfo(screenWidth, screenHeight, newTab, priority);
            tabsScreens.put(screen, screenInfo);
        }
    }

    public static void initScreenButtons(ScreenEvent.Init.Post event) {
        if (tabsScreens.containsKey(event.getScreen().getClass())) {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            ScreenInfo screenInfo = tabsScreens.get(event.getScreen().getClass());
            leftScreenPos = (event.getScreen().f_96543_ - screenInfo.width.apply((Player)Minecraft.m_91087_().f_91074_)) / 2;
            topScreenPos = (event.getScreen().f_96544_ - screenInfo.height.apply((Player)Minecraft.m_91087_().f_91074_)) / 2;
            if (topScreenPos - 22 < 0) {
                return;
            }
            startTabIndex = 0;
            currentTabsCount = 0;
            enabledTabs = new ArrayList<TabBase>();
            for (List<TabBase> tabBases : screenInfo.tabs.values()) {
                enabledTabs.addAll(tabBases.stream().filter(tabBase -> tabBase.isEnabled((Player)Minecraft.m_91087_().f_91074_)).toList());
            }
            int remainingWidth = screenInfo.width.apply((Player)Minecraft.m_91087_().f_91074_) - Config.Baked.tabsMenuOffsetX;
            for (TabBase tabBase2 : enabledTabs) {
                if (remainingWidth <= 26) continue;
                event.addListener((GuiEventListener)new TabButton(tabBase2, (Player)Minecraft.m_91087_().f_91074_, event.getScreen(), currentTabsCount, leftScreenPos, topScreenPos));
                remainingWidth -= 27;
                ++currentTabsCount;
            }
            if (enabledTabs.size() > currentTabsCount) {
                event.addListener((GuiEventListener)new NextTabsButton(currentTabsCount, leftScreenPos, topScreenPos, button -> TabsMenu.nextTabButtons(event.getScreen())));
            }
        }
    }

    public static void nextTabButtons(Screen screen) {
        List<GuiEventListener> tabButtons = screen.m_6702_().stream().filter(button -> button instanceof TabButton).toList();
        startTabIndex = startTabIndex + currentTabsCount >= enabledTabs.size() ? 0 : (startTabIndex += currentTabsCount + Math.min(enabledTabs.size() - currentTabsCount * 2 - startTabIndex, 0));
        int currentTabIndex = 0;
        for (TabBase tabBase : enabledTabs) {
            int tabIndexToUpdate = currentTabIndex - startTabIndex;
            if (tabIndexToUpdate >= currentTabsCount) break;
            if (tabIndexToUpdate >= 0) {
                ((TabButton)tabButtons.get(tabIndexToUpdate)).setTabBase(tabBase);
            }
            ++currentTabIndex;
        }
    }

    public static void register(TabBase tabBase) {
        LegendaryTabs.LOGGER.info("Tab " + tabBase.getClass().getName() + " registered");
        tabBase.initTabOnScreens();
    }

    public static class ScreenInfo {
        public Function<Player, Integer> width;
        public Function<Player, Integer> height;
        public Map<Integer, List<TabBase>> tabs;

        public ScreenInfo(Function<Player, Integer> width, Function<Player, Integer> height, TabBase newTab, int priority) {
            this.width = width;
            this.height = height;
            this.tabs = new TreeMap<Integer, List<TabBase>>();
            this.addTab(priority, newTab);
        }

        public void addTab(int priority, TabBase newTab) {
            if (this.tabs.containsKey(priority)) {
                this.tabs.get(priority).add(newTab);
            } else {
                ArrayList<TabBase> newTabsForPriority = new ArrayList<TabBase>();
                newTabsForPriority.add(newTab);
                this.tabs.put(priority, newTabsForPriority);
            }
        }
    }
}

