/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math.smoothvalue;

import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothValue;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class ExpSmoothVector2d
extends ExpSmoothValue<Vector2d> {
    public ExpSmoothVector2d() {
        super(new Vector2d(0.0), new Vector2d(1.0), new Vector2d(0.0), new Vector2d(0.0), new Vector2d(0.0));
    }

    public void setTarget(double x, double y) {
        ((Vector2d)this.target).set(x, y);
    }

    @Override
    public void setTarget(@NotNull Vector2d target) {
        ((Vector2d)this.target).set((Vector2dc)target);
    }

    @Override
    @NotNull
    public Vector2d get(double t) {
        return new Vector2d((Vector2dc)this.lastValue).lerp((Vector2dc)this.value, t);
    }

    @Override
    protected void saveLastValue() {
        ((Vector2d)this.lastValue).set((Vector2dc)this.value);
    }

    @Override
    protected void updateWithOutSavingLastValue(double period) {
        Vector2d t = LMath.pow(new Vector2d((Vector2dc)this.smoothFactor), new Vector2d((Vector2dc)this.smoothFactorWeight).mul(period)).negate().add(1.0, 1.0);
        LMath.lerp((Vector2d)this.value, (Vector2d)this.target, t);
    }

    @Override
    public void setValue(@NotNull Vector2d v) {
        ((Vector2d)this.value).set((Vector2dc)v);
    }

    @Override
    public void set(@NotNull Vector2d v) {
        ((Vector2d)this.value).set((Vector2dc)v);
        ((Vector2d)this.target).set((Vector2dc)v);
    }

    @Override
    public void setSmoothFactor(@NotNull Vector2d s) {
        ((Vector2d)this.smoothFactor).set((Vector2dc)s);
    }

    @Override
    public void setSmoothFactor(double smoothFactor) {
        this.setSmoothFactor(smoothFactor, smoothFactor);
    }

    @Override
    public void setMT(@NotNull Vector2d multiplier, @NotNull Vector2d time) {
        if (multiplier.x < 0.0 || multiplier.x > 1.0) {
            throw new IllegalArgumentException("Multiplier.x should in [0,1]: " + multiplier.x);
        }
        if (multiplier.y < 0.0 || multiplier.y > 1.0) {
            throw new IllegalArgumentException("Multiplier.y should in [0,1]: " + multiplier.y);
        }
        if (time.x < 0.0 || time.y < 0.0) {
            throw new IllegalArgumentException("Invalid time, non-negative required, but got " + String.valueOf(time));
        }
        ((Vector2d)this.smoothFactor).set(time.x == 0.0 ? 0.0 : Math.pow(multiplier.x, 1.0 / time.x), time.y == 0.0 ? 0.0 : Math.pow(multiplier.y, 1.0 / time.y));
    }

    @Override
    public void setHalflife(@NotNull Vector2d halflife) {
        this.setMT(new Vector2d(0.5), halflife);
    }

    @Override
    public void setHalflife(double halflife) {
        this.setMT(new Vector2d(0.5), new Vector2d(halflife));
    }

    public void setSmoothFactor(double x, double y) {
        ((Vector2d)this.smoothFactor).set(x, y);
    }

    public void setSmoothFactorWeight(double x, double y) {
        ((Vector2d)this.smoothFactorWeight).set(x, y);
    }

    public void setValue(double x, double y) {
        ((Vector2d)this.value).set(x, y);
    }
}

