/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math.smoothvalue;

import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpRotSmoothDouble;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothDouble;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public class ExpSmoothRotation {
    private final ExpRotSmoothDouble y = new ExpRotSmoothDouble(360.0);
    private final ExpSmoothDouble x = new ExpSmoothDouble();

    private ExpSmoothRotation() {
    }

    public void setHalflife(double halflife) {
        this.y.setHalflife(halflife);
        this.x.setHalflife(halflife);
    }

    public void setMT(double multiplier, double time) {
        this.y.setMT(multiplier, time);
        this.x.setMT(multiplier, time);
    }

    public void setSmoothFactor(double smoothFactor) {
        this.y.setSmoothFactor(smoothFactor);
        this.x.setSmoothFactor(smoothFactor);
    }

    public void setTarget(@NotNull Vector2d rot) {
        this.y.setTarget(rot.y);
        this.x.setTarget(LMath.clamp(rot.x, -90.0, 90.0));
    }

    public void update(double period) {
        this.y.update(period);
        this.x.update(period);
    }

    @NotNull
    public Vector2d get() {
        return new Vector2d(((Double)this.x.get()).doubleValue(), ((Double)this.y.get()).doubleValue());
    }

    @NotNull
    public Vector2d get(double t) {
        return new Vector2d(this.x.get(t).doubleValue(), this.y.get(t).doubleValue());
    }

    public void set(@NotNull Vector2d v) {
        this.y.set(v.y);
        this.x.set(LMath.clamp(v.x, -90.0, 90.0));
    }

    public void setSmoothFactorWeight(double weight) {
        this.y.setSmoothFactorWeight(weight);
        this.x.setSmoothFactorWeight(weight);
    }

    public void setValue(@NotNull Vector2d v) {
        this.y.setValue(v.y);
        this.x.setValue(LMath.clamp(v.x, -90.0, 90.0));
    }

    @NotNull
    public Vector2d getLast() {
        return new Vector2d(((Double)this.x.getLast()).doubleValue(), ((Double)this.y.getLast()).doubleValue());
    }

    @NotNull
    public static ExpSmoothRotation createWithHalflife(double halflife) {
        ExpSmoothRotation v = new ExpSmoothRotation();
        v.setHalflife(halflife);
        return v;
    }
}

