/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math.monolist;

import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.monolist.MonoList;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class StaticMonoList
implements MonoList {
    private final int sgn;
    private final double[] list;

    public StaticMonoList(double @NotNull [] list) {
        this.list = list;
        this.sgn = (int)Math.signum(list[1] - list[0]);
        if (!this.isMono()) {
            throw new IllegalArgumentException("Invalid list");
        }
    }

    private boolean isMono() {
        double lastValue = this.list[0];
        for (double value : this.list) {
            if (value == lastValue || Math.signum(value - lastValue) == (double)this.sgn) continue;
            return false;
        }
        return true;
    }

    @Override
    public double get(int i) {
        return this.list[i];
    }

    @Override
    public double offset(double value, int offset) {
        int i = this.iadsorption(value) + offset * this.sgn();
        i = LMath.clamp(i, 0, this.length() - 1);
        return this.list[i];
    }

    @Override
    public int iadsorption(double value) {
        int ileft = 0;
        int iright = this.length() - 1;
        int icenter = this.length() / 2;
        while (true) {
            if (this.list[icenter] < value) {
                ileft = icenter;
            } else if (this.list[icenter] > value) {
                iright = icenter;
            } else {
                return icenter;
            }
            if (iright - ileft == 1) break;
            icenter = (ileft + iright) / 2;
        }
        if (value - this.list[ileft] <= this.list[iright] - value) {
            return ileft;
        }
        return iright;
    }

    @Override
    public double adsorption(double value) {
        return this.list[this.iadsorption(value)];
    }

    @Override
    public double getNext(double value) {
        return this.offset(value, 1);
    }

    @Override
    public double getLast(double value) {
        return this.offset(value, -1);
    }

    @Override
    public int sgn() {
        return this.sgn;
    }

    @Override
    public int length() {
        return this.list.length;
    }

    @NotNull
    public static StaticMonoList linear(int length) {
        return StaticMonoList.of(length, d -> (double)d);
    }

    @NotNull
    public static StaticMonoList of(int length, @NotNull Function<Integer, Double> getter) {
        double[] list = new double[length];
        for (int i = 0; i < length; ++i) {
            list[i] = getter.apply(i);
        }
        return StaticMonoList.of(list);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static StaticMonoList of(double[] list) {
        return new StaticMonoList(list);
    }

    @NotNull
    public static StaticMonoList exp(int length) {
        return StaticMonoList.of(length, Math::exp);
    }

    @NotNull
    public static StaticMonoList squared(int length) {
        return StaticMonoList.of(length, i -> i * i);
    }

    @NotNull
    public static StaticMonoList of(int length, double min, double max, @NotNull Function<Double, Double> f, @NotNull Function<Double, Double> fInv) {
        double xmin = fInv.apply(min);
        double xrange = fInv.apply(max) - xmin;
        return StaticMonoList.of(length, i -> (Double)f.apply((double)i.intValue() * xrange / (double)length + xmin));
    }
}

