/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math.decisionmap;

import com.github.leawind.thirdperson.util.math.decisionmap.DecisionFactor;
import com.github.leawind.thirdperson.util.math.decisionmap.DecisionMapBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class DecisionMap<T> {
    public static final int MAX_FACTOR_COUNT = 32;
    private final List<DecisionFactor> factors;
    private final Map<String, DecisionFactor> factorMap = new HashMap<String, DecisionFactor>();
    private final Map<Integer, Supplier<T>> strategies;
    private final Supplier<T> defaultOperation;
    private int factorValues = 0;

    public DecisionMap(List<DecisionFactor> factorList, Map<Integer, Supplier<T>> strategyMap, Supplier<T> defaultOperation) {
        if (factorList.size() > 32) {
            throw new IllegalArgumentException("Too many factors. Max is 32, got " + factorList.size());
        }
        this.factors = new ArrayList<DecisionFactor>(factorList);
        int i = 0;
        for (DecisionFactor factor : this.factors) {
            this.factorMap.put(factor.getName(), factor);
            factor.index = i++;
        }
        this.strategies = new HashMap<Integer, Supplier<T>>(strategyMap);
        this.defaultOperation = defaultOperation;
    }

    public int getFactorCount() {
        return this.factors.size();
    }

    public int getFactorValues() {
        return this.factorValues;
    }

    @Nullable
    private DecisionFactor getFactor(String name) {
        return this.factorMap.get(name);
    }

    private DecisionFactor getFactor(int index) throws IndexOutOfBoundsException {
        return this.factors.get(index);
    }

    public void update(String name) {
        DecisionFactor factor = this.getFactor(name);
        if (factor == null) {
            throw new IllegalArgumentException("No such factor: " + name);
        }
        factor.update();
        this.factorValues &= ~(1 << factor.index);
        this.factorValues |= factor.getInt() << factor.index;
    }

    public void update(int index) throws IndexOutOfBoundsException {
        DecisionFactor factor = this.getFactor(index);
        factor.update();
        this.factorValues &= ~(1 << index);
        this.factorValues |= factor.getInt() << index;
    }

    public DecisionMap<T> updateAll() {
        for (int i = 0; i < this.factors.size(); ++i) {
            this.update(i);
        }
        return this;
    }

    public T make() {
        return this.strategies.getOrDefault(this.factorValues, this.defaultOperation).get();
    }

    public String toDescription() {
        HashSet<Supplier<T>> strategySet = new HashSet<Supplier<T>>(this.strategies.values());
        StringBuilder s = new StringBuilder("DecisionMap\n");
        s.append(String.format("\tTotally %d factors, %d strategies\n", this.factors.size(), strategySet.size()));
        s.append(String.format("\tSpecified cases: %d/%d\n", this.strategies.size(), (int)Math.pow(2.0, this.factors.size())));
        for (int i = this.factors.size() - 1; i >= 0; --i) {
            s.append(String.format("\t\t%2d. %s\n", i, this.factors.get(i).getName()));
        }
        return s.toString();
    }

    public String toDescriptionWithCases(boolean allCases) {
        HashSet<Supplier<T>> strategySet = new HashSet<Supplier<T>>(this.strategies.values());
        StringBuilder s = new StringBuilder("DecisionMap\n");
        s.append(String.format("\tTotally %d factors, %d strategies\n", this.factors.size(), strategySet.size()));
        s.append(String.format("\tSpecified cases: %d/%d\n", this.strategies.size(), (int)Math.pow(2.0, this.factors.size())));
        for (int i = this.factors.size() - 1; i >= 0; --i) {
            s.append(String.format("\t\t%2d. %s\n", i, this.factors.get(i).getName()));
        }
        int flagsMax = (1 << this.factors.size()) - 1;
        for (int flags = 0; flags <= flagsMax; ++flags) {
            if (!allCases && !this.strategies.containsKey(flags)) continue;
            s.append("\t");
            String flagsStr = Integer.toBinaryString(flags);
            s.append("0".repeat(this.factors.size() - flagsStr.length())).append(flagsStr);
            Supplier<T> strategy = this.strategies.get(flags);
            if (strategy != null) {
                s.append(String.format(" %s\n", strategy.getClass().getSimpleName()));
                continue;
            }
            s.append(" (Default)\n");
        }
        return s.toString();
    }

    public static <T> DecisionMapBuilder<T> builder() {
        return new DecisionMapBuilder();
    }
}

