/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util.math;

import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3i;

public interface LMath {
    @Contract(pure=true)
    public static Vector3d directionFromRotationDegree(Vector2d r) {
        return LMath.directionFromRotationDegree(r.x, r.y);
    }

    @Contract(pure=true)
    public static Vector2d rotationRadianFromDirection(Vector3d d) {
        d.normalize();
        return new Vector2d(-Math.asin(d.y), Math.atan2(-d.x, d.z));
    }

    @Contract(pure=true)
    public static Vector3d directionFromRotationDegree(double x, double y) {
        double h = Math.cos(-y * (Math.PI / 180) - Math.PI);
        double i = Math.sin(-y * (Math.PI / 180) - Math.PI);
        double j = -Math.cos(-x * (Math.PI / 180));
        double k = Math.sin(-x * (Math.PI / 180));
        return new Vector3d(i * j, k, h * j);
    }

    @Contract(pure=true)
    public static Vector3d rotateRadian(Vector3d vec, float dy, float dx) {
        return LMath.directionFromRotationDegree(LMath.rotationRadianFromDirection(vec).add((Vector2dc)new Vector2d((double)dx, (double)dy))).mul(vec.length());
    }

    @Contract(pure=true)
    public static Vector3d rotateRadian(Vector3d vec, Vector2d rotation) {
        return LMath.directionFromRotationDegree(LMath.rotationRadianFromDirection(vec).add((Vector2dc)rotation)).mul(vec.length());
    }

    @Contract(pure=true)
    public static Vector3d rotateDegree(Vector3d vec, double dy, double dx) {
        return LMath.directionFromRotationDegree(LMath.rotationDegreeFromDirection(vec).add((Vector2dc)new Vector2d(dx, dy))).mul(vec.length());
    }

    @Contract(pure=true)
    public static Vector2d rotationDegreeFromDirection(Vector3d d) {
        Vector3d nd = new Vector3d((Vector3dc)d).normalize();
        return new Vector2d(-Math.toDegrees(Math.asin(nd.y)), Math.toDegrees(Math.atan2(-nd.x, nd.z)));
    }

    @Contract(pure=true)
    public static Vector3d rotateDegree(Vector3d vec, Vector2d rotationAngle) {
        return LMath.directionFromRotationDegree(LMath.rotationDegreeFromDirection(vec).add((Vector2dc)rotationAngle)).mul(vec.length());
    }

    @Contract(pure=true)
    public static double rotationDegreeFromDirection(Vector2d d) {
        return -Math.toDegrees(Math.atan2(d.x, d.y));
    }

    @Contract(pure=true)
    public static Vector2d directionFromRotationDegree(double yRot) {
        double x = Math.sin(yRot * (Math.PI / 180) + Math.PI);
        double z = -Math.cos(yRot * (Math.PI / 180) + Math.PI);
        return new Vector2d(x, z);
    }

    @Contract(pure=true)
    public static Vector3d toVector3d(Vec3 v) {
        return new Vector3d(v.f_82479_, v.f_82480_, v.f_82481_);
    }

    @Contract(pure=true)
    public static Vector3d toVector3d(Vector3f v) {
        return new Vector3d((double)v.x, (double)v.y, (double)v.z);
    }

    @Contract(pure=true)
    public static Vec3i toVec3i(Vec3 v) {
        return new Vec3i((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_);
    }

    @Contract(pure=true)
    public static Vec3i toVec3i(Vector3i v) {
        return new Vec3i(v.x, v.y, v.z);
    }

    @Contract(pure=true)
    public static Vec3 toVec3(Vector3d v) {
        return new Vec3(v.x, v.y, v.z);
    }

    @Contract(value="_, _ -> param1")
    @NotNull
    public static Vector2d pow(Vector2d v, Vector2d p) {
        v.x = Math.pow(v.x, p.x);
        v.y = Math.pow(v.y, p.y);
        return v;
    }

    @Contract(value="_, _ -> param1")
    @NotNull
    public static Vector3d pow(Vector3d v, Vector3d p) {
        v.x = Math.pow(v.x, p.x);
        v.y = Math.pow(v.y, p.y);
        v.z = Math.pow(v.z, p.z);
        return v;
    }

    @Contract(pure=true)
    public static int clamp(int d, int min, int max) {
        return d < min ? min : Math.min(d, max);
    }

    @Contract(pure=true)
    public static long clamp(long d, long min, long max) {
        return d < min ? min : Math.min(d, max);
    }

    @Contract(pure=true)
    public static float clamp(float d, float min, float max) {
        return d < min ? min : Math.min(d, max);
    }

    @Contract(pure=true)
    public static double clamp(double d, double min, double max) {
        return d < min ? min : Math.min(d, max);
    }

    @Contract(pure=true)
    public static void clamp(Vector2d v, double min, double max) {
        v.x = LMath.clamp(v.x, min, max);
        v.y = LMath.clamp(v.y, min, max);
    }

    @Contract(pure=true)
    public static double lerp(double start, double end, double t) {
        return start + t * (end - start);
    }

    public static void lerp(Vector2d start, Vector2d end, Vector2d t) {
        start.x = LMath.lerp(start.x, end.x, t.x);
        start.y = LMath.lerp(start.y, end.y, t.y);
    }

    public static void lerp(Vector3d start, Vector3d end, Vector3d t) {
        start.x = LMath.lerp(start.x, end.x, t.x);
        start.y = LMath.lerp(start.y, end.y, t.y);
        start.z = LMath.lerp(start.z, end.z, t.z);
    }

    @Contract(pure=true)
    public static double floorMod(double x, double y) {
        return (x % y + y) % y;
    }

    @Contract(pure=true)
    public static float floorMod(float x, float y) {
        return (x % y + y) % y;
    }

    @Contract(pure=true)
    public static int floorMod(int x, int y) {
        return Math.floorMod(x, y);
    }

    @Contract(pure=true)
    public static long floorMod(long x, long y) {
        return Math.floorMod(x, y);
    }

    public static boolean isWithinRadian(double x, double a, double b) {
        double tp = Math.sin(b - a);
        return Math.sin(b - x) * tp > 0.0 && Math.sin(x - a) * tp > 0.0;
    }

    public static double subtractRadian(double a, double b) {
        double x = Math.abs(Math.IEEEremainder(a - b, Math.PI * 2));
        return x > Math.PI ? Math.PI * 2 - x : x;
    }

    public static boolean isWithinDegrees(double x, double a, double b) {
        return LMath.isWithinRadian(x * (Math.PI / 180), a * (Math.PI / 180), b * (Math.PI / 180));
    }

    public static double subtractDegrees(double a, double b) {
        double x = Math.abs(Math.IEEEremainder(a - b, 360.0));
        return x > 180.0 ? 360.0 - x : x;
    }
}

