/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.util;

import com.github.leawind.thirdperson.ThirdPerson;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemPredicateUtil {
    private static final Pattern RGX_NBT = Pattern.compile("^(\\{.*})$");
    private static final Pattern RGX_TAG_NBT = Pattern.compile("^#([a-z0-9.:_]+)(\\{.*})?$");
    private static final Pattern RGX_KEY_NBT = Pattern.compile("^([a-z0-9.:_]+)(\\{.*})?$");

    @NotNull
    public static Optional<Component> supplyError(String pattern) {
        try {
            ItemPredicateUtil.parse("minecraft", pattern);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of(Component.m_237113_((String)e.getMessage()));
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    @SafeVarargs
    public static boolean anyMatches(@NotNull ItemStack itemStack, Iterable<ItemPredicate> ... predicatesList) {
        if (itemStack.m_41619_()) {
            return false;
        }
        for (Iterable<ItemPredicate> predicates : predicatesList) {
            for (ItemPredicate predicate : predicates) {
                if (!predicate.m_45049_(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int addToSet(@NotNull String defaultNamespace, @NotNull Set<ItemPredicate> predicates, @Nullable Iterable<String> patterns) {
        int count = 0;
        if (patterns != null) {
            for (String pattern : patterns) {
                try {
                    predicates.add(ItemPredicateUtil.parse(defaultNamespace, pattern));
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    ThirdPerson.LOGGER.error("Skip invalid item pattern: {}, because {}", (Object)pattern, (Object)e.getMessage());
                }
                catch (IllegalStateException e) {
                    ThirdPerson.LOGGER.warn("Skip invalid item pattern: {}, because {}", (Object)pattern, (Object)e.getMessage());
                }
            }
        }
        return count;
    }

    public static ItemPredicate parse(String pattern) throws IllegalArgumentException, IllegalStateException {
        return ItemPredicateUtil.parse("minecraft", pattern);
    }

    public static ItemPredicate parse(String defaultNs, String pattern) throws IllegalArgumentException, IllegalStateException {
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("Empty item pattern");
        }
        if (pattern.startsWith("{")) {
            return ItemPredicateUtil.parseNbtPredicate(defaultNs, pattern);
        }
        if (pattern.startsWith("#")) {
            return ItemPredicateUtil.parseTagPredicate(defaultNs, pattern);
        }
        return ItemPredicateUtil.parseKeyPredicate(defaultNs, pattern);
    }

    private static ItemPredicate parseNbtPredicate(String defaultNs, String pattern) throws IllegalArgumentException {
        if (!RGX_NBT.matcher(pattern).matches()) {
            throw new IllegalArgumentException(String.format("Invalid NBT: %s", pattern));
        }
        try {
            return ItemPredicateUtil.of(defaultNs, pattern, null, null);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid NBT: %s, %s", pattern, e.getMessage()));
        }
    }

    private static ItemPredicate parseTagPredicate(String defaultNs, String pattern) throws IllegalArgumentException {
        Matcher m = RGX_TAG_NBT.matcher(pattern);
        if (m.matches()) {
            return ItemPredicateUtil.of(defaultNs, m.group(2), m.group(1), null);
        }
        throw new IllegalArgumentException(String.format("Invalid item tag: %s", pattern));
    }

    private static ItemPredicate parseKeyPredicate(String defaultNs, String pattern) throws IllegalArgumentException, IllegalStateException {
        Matcher m = RGX_KEY_NBT.matcher(pattern);
        if (m.matches()) {
            return ItemPredicateUtil.of(defaultNs, m.group(2), null, m.group(1));
        }
        throw new IllegalArgumentException(String.format("Invalid item pattern: %s", pattern));
    }

    private static ItemPredicate of(String defaultNs, @Nullable String nbtPattern, @Nullable String tagKeyPattern, @Nullable String itemKeyPattern) throws IllegalArgumentException, IllegalStateException {
        ImmutableSet items;
        NbtPredicate nbt;
        TagKey tagKey = null;
        try {
            nbt = nbtPattern == null ? NbtPredicate.f_57471_ : new NbtPredicate(TagParser.m_129359_((String)nbtPattern));
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (tagKeyPattern != null) {
            tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ItemPredicateUtil.parseResourceLocation(defaultNs, tagKeyPattern));
        }
        if (itemKeyPattern == null) {
            items = null;
        } else if (itemKeyPattern.isEmpty()) {
            items = ImmutableSet.of();
        } else {
            ResourceLocation resourceLocation = ItemPredicateUtil.parseResourceLocation(defaultNs, itemKeyPattern);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(resourceLocation);
            if (item == Items.f_41852_) {
                throw new IllegalStateException(String.format("Item %s does not exist or it's minecraft:air", resourceLocation));
            }
            items = ImmutableSet.of((Object)item);
        }
        return new ItemPredicate(tagKey, (Set)items, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, nbt);
    }

    private static ResourceLocation parseResourceLocation(String defaultNamespace, String pattern) throws IllegalArgumentException {
        try {
            return pattern.indexOf(58) < 0 ? new ResourceLocation(defaultNamespace, pattern) : new ResourceLocation(pattern);
        }
        catch (ResourceLocationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

