/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.mixin;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.api.base.GameEvents;
import com.github.leawind.thirdperson.api.client.event.RenderEntityEvent;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class}, priority=2000)
public class LevelRendererMixin {
    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelRenderEntity(Entity entity, double x, double y, double z, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, CallbackInfo ci) {
        RenderEntityEvent event;
        if (GameEvents.renderEntity != null && !GameEvents.renderEntity.apply(event = new RenderEntityEvent(entity, partialTick)).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")})
    private void postRenderEntity(Entity entity, double x, double y, double z, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, CallbackInfo ci) {
        if (multiBufferSource instanceof MultiBufferSource.BufferSource && ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && entity == ThirdPerson.ENTITY_AGENT.getRawCameraEntity() && ThirdPersonStatus.useCameraEntityOpacity(partialTick) && ThirdPersonStatus.shouldRenderCameraEntity(partialTick)) {
            ((MultiBufferSource.BufferSource)multiBufferSource).m_173043_();
        }
    }
}

