/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core.rotation;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.util.math.LMath;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public enum RotateTargetEnum {
    NONE(partialTick -> ThirdPerson.ENTITY_AGENT.getRawRotation(partialTick.floatValue())),
    INTEREST_POINT(partialTick -> {
        Vec3 point = ThirdPerson.ENTITY_AGENT.getInterestPoint();
        if (point == null) {
            return NONE.getRotation(partialTick.floatValue());
        }
        LocalPlayer player = ThirdPerson.ENTITY_AGENT.getRawPlayerEntity();
        Vec3 toInterestedPoint = point.m_82546_(player.m_20299_(partialTick.floatValue()));
        if (toInterestedPoint.m_82553_() < 1.0E-5) {
            return NONE.getRotation(partialTick.floatValue());
        }
        Vector2d playerRot = ThirdPerson.ENTITY_AGENT.getRawRotation(1.0f);
        ThirdPerson.FINITE_CHECKER.checkOnce(playerRot.x, playerRot.y);
        Vector2d rot = LMath.rotationDegreeFromDirection(LMath.toVector3d(toInterestedPoint));
        ThirdPerson.FINITE_CHECKER.checkOnce(rot.x, rot.y);
        double leftBound = player.f_20883_ - 50.0f;
        double rightBound = player.f_20883_ + 50.0f;
        playerRot.y = LMath.isWithinDegrees(rot.y, leftBound, rightBound) ? rot.y : (LMath.subtractDegrees(rot.y, leftBound) < LMath.subtractDegrees(rot.y, rightBound) ? leftBound : rightBound);
        playerRot.x = rot.x;
        return playerRot;
    }),
    CAMERA_ROTATION(partialTick -> ThirdPerson.CAMERA_AGENT.getRotation()),
    CAMERA_HIT_RESULT(partialTick -> {
        HitResult cameraHitResult = ThirdPerson.CAMERA_AGENT.getHitResult();
        if (cameraHitResult.m_6662_() == HitResult.Type.MISS) {
            return CAMERA_ROTATION.getRotation(partialTick.floatValue());
        }
        Vector3d cameraHitPosition = LMath.toVector3d(cameraHitResult.m_82450_());
        Vector3d eyePosition = ThirdPerson.ENTITY_AGENT.getRawEyePosition(partialTick.floatValue());
        return LMath.rotationDegreeFromDirection(cameraHitPosition.sub((Vector3dc)eyePosition));
    }),
    PREDICTED_TARGET_ENTITY(partialTick -> {
        Vector2d rotation = CAMERA_HIT_RESULT.getRotation(partialTick.floatValue());
        if (!ThirdPerson.getConfig().enable_target_entity_predict || !ThirdPerson.ENTITY_AGENT.isControlled()) {
            return rotation;
        }
        Entity predicted = ThirdPerson.CAMERA_AGENT.predictTargetEntity(partialTick.floatValue());
        if (predicted == null) {
            return rotation;
        }
        Camera camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
        Vector3d playerEyePos = ThirdPerson.ENTITY_AGENT.getRawEyePosition(partialTick.floatValue());
        Vector3d cameraPos = LMath.toVector3d(camera.m_90583_());
        Vector3d targetPos = LMath.toVector3d(predicted.m_20318_(partialTick.floatValue()));
        Vector3d end = LMath.toVector3d(camera.m_253058_()).normalize(cameraPos.distance((Vector3dc)targetPos)).add((Vector3dc)cameraPos);
        Vector3d eyeToEnd = end.sub((Vector3dc)playerEyePos);
        if (eyeToEnd.length() < 1.0E-5) {
            return rotation;
        }
        return LMath.rotationDegreeFromDirection(eyeToEnd);
    }),
    IMPULSE_DIRECTION(partialTick -> ThirdPersonStatus.impulseHorizon.length() < 1.0E-5 ? NONE.getRotation(partialTick.floatValue()) : LMath.rotationDegreeFromDirection(ThirdPersonStatus.impulse)),
    HORIZONTAL_IMPULSE_DIRECTION(partialTick -> {
        if (ThirdPersonStatus.impulseHorizon.length() < 1.0E-5) {
            return NONE.getRotation(partialTick.floatValue());
        }
        double absoluteYRotDegree = LMath.rotationDegreeFromDirection(ThirdPersonStatus.impulseHorizon);
        return new Vector2d(0.1, absoluteYRotDegree);
    });

    private final Function<Float, Vector2d> rotationGetter;

    private RotateTargetEnum(Function<Float, Vector2d> rotationGetter) {
        this.rotationGetter = rotationGetter;
    }

    @NotNull
    public Vector2d getRotation(float partialTick) {
        Vector2d rotation = this.rotationGetter.apply(Float.valueOf(partialTick));
        ThirdPerson.FINITE_CHECKER.checkOnce(rotation.x, rotation.y);
        return rotation;
    }
}

