/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.core;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonResources;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.rotation.RotateStrategy;
import com.github.leawind.thirdperson.core.rotation.RotateTargetEnum;
import com.github.leawind.thirdperson.core.rotation.SmoothTypeEnum;
import com.github.leawind.thirdperson.util.FiniteChecker;
import com.github.leawind.thirdperson.util.ItemPredicateUtil;
import com.github.leawind.thirdperson.util.math.LMath;
import com.github.leawind.thirdperson.util.math.decisionmap.DecisionMap;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothDouble;
import com.github.leawind.thirdperson.util.math.smoothvalue.ExpSmoothRotation;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class EntityAgent {
    public final FiniteChecker FINITE_CHECKER = new FiniteChecker(err -> ThirdPerson.LOGGER.error(err.toString()));
    private final Minecraft minecraft;
    private final ExpSmoothRotation smoothRotation = ExpSmoothRotation.createWithHalflife(0.5);
    private final ExpSmoothDouble smoothOpacity;
    public double vehicleTotalSizeCached = 1.0;
    @NotNull
    private RotateTargetEnum rotateTarget = RotateTargetEnum.NONE;
    @NotNull
    private SmoothTypeEnum smoothRotationType = SmoothTypeEnum.EXP_LINEAR;
    private final DecisionMap<Double> rotateDecisionMap = RotateStrategy.build();
    private boolean wasAiming = false;

    public EntityAgent(@NotNull Minecraft minecraft) {
        this.minecraft = minecraft;
        this.smoothOpacity = new ExpSmoothDouble();
        this.smoothOpacity.set(1.0);
        ThirdPerson.LOGGER.debug(this.rotateDecisionMap.toDescription());
    }

    public boolean isCameraEntityExist() {
        return this.minecraft.f_91075_ != null;
    }

    public void reset() {
        ThirdPerson.LOGGER.debug("Reset EntityAgent");
        this.smoothOpacity.set(0.0);
        this.wasAiming = false;
    }

    @NotNull
    public RotateTargetEnum getRotateTarget() {
        return this.rotateTarget;
    }

    public void setRotateTarget(@NotNull RotateTargetEnum rotateTarget) {
        this.rotateTarget = rotateTarget;
    }

    @NotNull
    public SmoothTypeEnum getRotationSmoothType() {
        return this.smoothRotationType;
    }

    public void setRotationSmoothType(@NotNull SmoothTypeEnum smoothType) {
        this.smoothRotationType = smoothType;
    }

    public void setSmoothRotationHalflife(double halflife) {
        this.smoothRotation.setHalflife(halflife);
    }

    public float getSmoothOpacity(float partialTick) {
        return this.smoothOpacity.get(partialTick).floatValue();
    }

    public ExpSmoothRotation getSmoothRotation() {
        return this.smoothRotation;
    }

    @PerformanceSensitive
    public void onRenderTickStart(double now, double period, float partialTick) {
        if (ThirdPersonStatus.isRenderingInThirdPerson() && this.isControlled() && !ThirdPersonStatus.shouldCameraTurnWithEntity()) {
            Vector2d targetRotation = this.getRotateTarget().getRotation(partialTick);
            this.smoothRotation.setTarget(targetRotation);
            switch (this.smoothRotationType) {
                case HARD: {
                    this.setRawRotation(targetRotation);
                    break;
                }
                case LINEAR: 
                case EXP_LINEAR: {
                    this.setRawRotation(this.smoothRotation.get(partialTick));
                    break;
                }
                case EXP: {
                    this.smoothRotation.update(period);
                    this.setRawRotation(this.smoothRotation.get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid smooth rotation type: " + String.valueOf((Object)this.smoothRotationType));
                }
            }
        }
    }

    public void onClientTickStart() {
        if (ThirdPersonStatus.clientTicks % 2 == 0) {
            this.vehicleTotalSizeCached = this.getVehicleTotalSize();
        }
        ++ThirdPersonStatus.clientTicks;
        this.wasAiming = this.isAiming();
        ThirdPerson.getConfig().getCameraOffsetScheme().setAiming(this.wasAiming());
        this.updateRotateStrategy();
        this.updateBodyRotation();
        this.updateSmoothOpacity(0.05, 1.0f);
        switch (this.smoothRotationType) {
            case HARD: 
            case EXP: {
                break;
            }
            case LINEAR: 
            case EXP_LINEAR: {
                this.smoothRotation.setTarget(this.getRotateTarget().getRotation(1.0f));
                this.smoothRotation.update(0.05);
            }
        }
    }

    public void setRawRotation(@NotNull Vector2d rot) {
        this.FINITE_CHECKER.checkOnce(rot.x, rot.y);
        LocalPlayer entity = this.getRawPlayerEntity();
        entity.f_19859_ = (float)rot.y;
        entity.m_146922_(entity.f_19859_);
        entity.f_19860_ = (float)rot.x;
        entity.m_146926_(entity.f_19860_);
    }

    public boolean isControlled() {
        return this.getRawPlayerEntity() == this.minecraft.f_91075_;
    }

    @NotNull
    public Entity getRawCameraEntity() {
        return Objects.requireNonNull(this.minecraft.f_91075_);
    }

    @NotNull
    public LocalPlayer getRawPlayerEntity() {
        return Objects.requireNonNull(this.minecraft.f_91074_);
    }

    @NotNull
    public Vector3d getRawEyePosition(float partialTick) {
        return LMath.toVector3d(this.getRawCameraEntity().m_20299_(partialTick));
    }

    @NotNull
    public Vector2d getRawRotation(float partialTick) {
        Entity entity = this.getRawCameraEntity();
        return new Vector2d((double)entity.m_5686_(partialTick), (double)entity.m_5675_(partialTick));
    }

    public boolean isEyeInWall(@NotNull ClipContext.ShapeGetter shapeGetter) {
        Entity cameraEntity = this.getRawCameraEntity();
        Vec3 eyePos = cameraEntity.m_146892_();
        BlockPos blockPos = BlockPos.m_274561_((double)eyePos.f_82479_, (double)eyePos.f_82480_, (double)eyePos.f_82481_);
        BlockState blockState = cameraEntity.m_9236_().m_8055_(blockPos);
        AABB eyeAabb = AABB.m_165882_((Vec3)eyePos, (double)0.8, (double)1.0E-6, (double)0.8);
        return shapeGetter.m_7544_(blockState, (BlockGetter)cameraEntity.m_9236_(), blockPos, CollisionContext.m_82749_()).m_83299_().stream().anyMatch(a -> a.m_82338_(blockPos).m_82381_(eyeAabb));
    }

    public boolean isInteracting() {
        if (!this.isControlled()) {
            LivingEntity livingEntity;
            Entity entity = this.getRawCameraEntity();
            return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6117_();
        }
        Options options = this.minecraft.f_91066_;
        return options.f_92095_.m_90857_() || options.f_92096_.m_90857_() || options.f_92097_.m_90857_();
    }

    public boolean isFallFlying() {
        LivingEntity livingEntity;
        Entity entity = this.getRawCameraEntity();
        return entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21255_();
    }

    public boolean isSprinting() {
        return this.getRawCameraEntity().m_20142_();
    }

    public boolean isEating() {
        Entity entity = this.getRawCameraEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.m_21211_().m_41614_();
        }
        return false;
    }

    public boolean isAiming() {
        Config config = ThirdPerson.getConfig();
        if (ThirdPersonStatus.doesPlayerWantToAim()) {
            return true;
        }
        Entity entity = this.getRawCameraEntity();
        if (entity instanceof LivingEntity) {
            boolean shouldBeAiming;
            UseAnim anim;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (config.determine_aim_mode_by_animation && livingEntity.m_6117_() && ((anim = livingEntity.m_21211_().m_41780_()) == UseAnim.BOW || anim == UseAnim.SPEAR)) {
                return true;
            }
            boolean bl = shouldBeAiming = ItemPredicateUtil.anyMatches(livingEntity.m_21205_(), config.getHoldToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.holdToAimItemPredicates) || ItemPredicateUtil.anyMatches(livingEntity.m_21206_(), config.getHoldToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.holdToAimItemPredicates);
            if (livingEntity.m_6117_()) {
                shouldBeAiming |= ItemPredicateUtil.anyMatches(livingEntity.m_21211_(), config.getUseToAimItemPredicates(), ThirdPersonResources.itemPredicateManager.useToAimItemPredicates);
            }
            return shouldBeAiming;
        }
        return false;
    }

    public boolean wasAiming() {
        return this.wasAiming;
    }

    public AABB getBoundingBox(float partialTick) {
        Entity entity = this.getRawCameraEntity();
        return entity.m_6972_(entity.m_20089_()).m_20393_(entity.m_20318_(partialTick));
    }

    public double boxDistanceTo(@NotNull Vector3d target, float partialTick) {
        AABB aabb = this.getBoundingBox(partialTick);
        Vector3d c = new Vector3d(LMath.clamp(target.x, aabb.f_82288_, aabb.f_82291_), LMath.clamp(target.y, aabb.f_82289_, aabb.f_82292_), LMath.clamp(target.z, aabb.f_82290_, aabb.f_82293_));
        return c.distance((Vector3dc)target);
    }

    public double getBodyRadius() {
        return (double)this.getRawCameraEntity().m_20205_() * 0.8660254037844386;
    }

    public double columnDistanceTo(@NotNull Vector3d target, float partialTick) {
        Entity entity = this.getRawCameraEntity();
        Vector3d c = LMath.toVector3d(entity.m_20318_(partialTick));
        double maxY = c.y + (double)entity.m_20192_();
        c.y = LMath.clamp(target.y, c.y, maxY);
        double dist = c.distance((Vector3dc)target);
        if (maxY > target.y && target.y > c.y) {
            dist = Math.max(0.0, dist - this.getBodyRadius());
        }
        return dist;
    }

    private void updateRotateStrategy() {
        this.setSmoothRotationHalflife(this.rotateDecisionMap.updateAll().make());
    }

    private void updateBodyRotation() {
        LocalPlayer player;
        Config config = ThirdPerson.getConfig();
        if (config.auto_turn_body_drawing_a_bow && ThirdPerson.ENTITY_AGENT.isControlled() && (player = this.getRawPlayerEntity()).m_6117_() && player.m_21211_().m_150930_(Items.f_42411_)) {
            double k;
            double d = k = player.m_7655_() == InteractionHand.MAIN_HAND ? 1.0 : -1.0;
            if (this.minecraft.f_91066_.m_232107_().m_231551_() == HumanoidArm.LEFT) {
                k = -k;
            }
            player.f_20883_ = (float)(k * 45.0 + (double)player.m_146908_());
        }
    }

    private void updateSmoothOpacity(double period, float partialTick) {
        double targetOpacity = 1.0;
        Config config = ThirdPerson.getConfig();
        if (config.player_fade_out_enabled) {
            double C = 0.36;
            Vector3d cameraPosition = LMath.toVector3d(ThirdPerson.CAMERA_AGENT.getRawCamera().m_90583_());
            double distance = this.getRawEyePosition(partialTick).distance((Vector3dc)cameraPosition);
            targetOpacity = (distance - 0.36) / 0.64;
            this.FINITE_CHECKER.checkOnce(targetOpacity);
            if (targetOpacity > config.gaze_opacity && !this.isFallFlying() && ThirdPerson.CAMERA_AGENT.isLookingAt(this.getRawCameraEntity())) {
                targetOpacity = config.gaze_opacity;
            }
        }
        this.smoothOpacity.setTarget(LMath.clamp(targetOpacity, 0.0, 1.0));
        this.smoothOpacity.setHalflife(0.0625 * (this.wasAiming() ? 0.25 : 1.0));
        this.smoothOpacity.update(period);
    }

    @Nullable
    public Vec3 getInterestPoint() {
        if (LMath.subtractDegrees(this.getRawPlayerEntity().f_20883_, ThirdPerson.CAMERA_AGENT.getRelativeRotation().y) > 90.0) {
            return ThirdPerson.CAMERA_AGENT.getHitResult().m_82450_();
        }
        return LMath.toVec3(ThirdPerson.CAMERA_AGENT.getRawCameraPosition());
    }

    public double getVehicleTotalSize() {
        Entity root = this.getRawCameraEntity().m_20201_();
        AABB bb = root.m_142429_().map(Entity::m_20191_).reduce(AABB::m_82367_).orElse(root.m_20191_());
        return Math.hypot(Math.hypot(bb.m_82362_(), bb.m_82376_()), bb.m_82385_());
    }
}

