/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson.config;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.config.AbstractConfig;
import com.github.leawind.thirdperson.core.cameraoffset.CameraOffsetScheme;
import com.github.leawind.thirdperson.util.ItemPredicateUtil;
import com.github.leawind.thirdperson.util.math.monolist.MonoList;
import com.github.leawind.thirdperson.util.math.monolist.StaticMonoList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config
extends AbstractConfig {
    @NotNull
    public static final Config DEFAULTS = new Config();
    @NotNull
    private final CameraOffsetScheme cameraOffsetScheme = new CameraOffsetScheme(this);
    @NotNull
    private final Set<ItemPredicate> holdToAimItemPredicates = new HashSet<ItemPredicate>();
    @NotNull
    private final Set<ItemPredicate> useToAimItemPredicates = new HashSet<ItemPredicate>();
    @NotNull
    private final Set<ItemPredicate> useToFirstPersonItemPredicates = new HashSet<ItemPredicate>();
    @Nullable
    private MonoList distanceMonoList;

    public Config() {
        this.update();
    }

    public void update() {
        if (this.normal_rotate_mode == null) {
            this.normal_rotate_mode = Config.DEFAULTS.normal_rotate_mode;
        }
        this.updateDistancesMonoList();
        this.updateItemPredicates();
    }

    public void updateDistancesMonoList() {
        ThirdPerson.LOGGER.debug("Updating distances mono list");
        this.distanceMonoList = StaticMonoList.of(this.available_distance_count, this.camera_distance_min, this.camera_distance_max, i -> i * i, Math::sqrt);
    }

    public void updateItemPredicates() {
        this.holdToAimItemPredicates.clear();
        this.useToAimItemPredicates.clear();
        this.useToFirstPersonItemPredicates.clear();
        int count = ItemPredicateUtil.addToSet("minecraft", this.holdToAimItemPredicates, this.hold_to_aim_item_patterns);
        if (count > 0) {
            ThirdPerson.LOGGER.info("Loaded {} hold_to_aim item patterns from configuration", (Object)count);
        }
        if ((count = ItemPredicateUtil.addToSet("minecraft", this.useToAimItemPredicates, this.use_to_aim_item_patterns)) > 0) {
            ThirdPerson.LOGGER.info("Loaded {}  use_to_aim item patterns from configuration", (Object)count);
        }
        if ((count = ItemPredicateUtil.addToSet("minecraft", this.useToFirstPersonItemPredicates, this.use_to_first_person_patterns)) > 0) {
            ThirdPerson.LOGGER.info("Loaded {} use_to_first_person item patterns from configuration", (Object)count);
        }
    }

    @NotNull
    public Set<ItemPredicate> getHoldToAimItemPredicates() {
        return this.holdToAimItemPredicates;
    }

    @NotNull
    public Set<ItemPredicate> getUseToAimItemPredicates() {
        return this.useToAimItemPredicates;
    }

    @NotNull
    public Set<ItemPredicate> getUseToFirstPersonItemPredicates() {
        return this.useToFirstPersonItemPredicates;
    }

    @NotNull
    public CameraOffsetScheme getCameraOffsetScheme() {
        return this.cameraOffsetScheme;
    }

    @NotNull
    public MonoList getDistanceMonoList() {
        return Objects.requireNonNull(this.distanceMonoList);
    }
}

