/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonConstants;
import com.github.leawind.thirdperson.ThirdPersonKeys;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.rotation.RotateTargetEnum;
import com.github.leawind.thirdperson.core.rotation.SmoothTypeEnum;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector3d;

public final class ThirdPersonStatus {
    @NotNull
    public static final Vector3d impulse = new Vector3d(0.0);
    @NotNull
    public static final Vector2d impulseHorizon = new Vector2d(0.0);
    public static int clientTicks = 0;
    public static boolean isToggleToAiming = false;
    public static double lastRenderTickTimeStamp = 0.0;
    public static boolean wasRenderInThirdPersonLastRenderTick = false;
    public static boolean wasShouldCameraTurnWithEntity = false;
    public static int ticksSinceLeaveNarrowSpace = 16;
    public static boolean forceThirdPersonCrosshair = false;
    public static boolean isPerspectiveInverted = false;

    public static boolean isAdjustingCameraOffset() {
        return ThirdPersonStatus.isAdjustingCameraDistance();
    }

    public static boolean isAdjustingCameraDistance() {
        return ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && ThirdPersonKeys.ADJUST_POSITION.m_90857_();
    }

    public static boolean isRenderingInThirdPerson() {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        return !cameraType.m_90612_() && !cameraType.m_90613_();
    }

    public static boolean shouldRenderThirdPersonCrosshair() {
        Config config = ThirdPerson.getConfig();
        return ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson() && (ThirdPerson.ENTITY_AGENT.wasAiming() ? config.render_crosshair_when_aiming : config.render_crosshair_when_not_aiming && (!ThirdPerson.ENTITY_AGENT.isFallFlying() || !config.hide_crosshair_when_flying));
    }

    public static boolean doesPlayerWantToAim() {
        return isToggleToAiming || ThirdPersonKeys.FORCE_AIMING.m_90857_();
    }

    public static boolean shouldPickFromCamera() {
        Player player;
        if (!ThirdPerson.ENTITY_AGENT.isCameraEntityExist()) {
            return false;
        }
        if (!ThirdPerson.getConfig().use_camera_pick_in_creative) {
            return false;
        }
        Entity entity = ThirdPerson.ENTITY_AGENT.getRawCameraEntity();
        return entity instanceof Player && (player = (Player)entity).m_7500_();
    }

    public static boolean shouldRenderCameraEntity(float partialTick) {
        return ThirdPerson.ENTITY_AGENT.getSmoothOpacity(partialTick) > 0.01f && ThirdPerson.ENTITY_AGENT.columnDistanceTo(ThirdPerson.CAMERA_AGENT.getRawCameraPosition(), partialTick) > ThirdPerson.getConfig().player_invisible_threshold;
    }

    public static boolean useCameraEntityOpacity(float partialTick) {
        return ThirdPerson.ENTITY_AGENT.getSmoothOpacity(partialTick) < 0.99f;
    }

    public static boolean shouldCameraTurnWithEntity() {
        return ThirdPerson.ENTITY_AGENT.getRotateTarget() == RotateTargetEnum.CAMERA_ROTATION && ThirdPerson.ENTITY_AGENT.getRotationSmoothType() == SmoothTypeEnum.HARD;
    }

    public static boolean calcIsInNarrowSpace(Entity entity) {
        boolean isInNarrowSpace = true;
        BlockPos center = BlockPos.m_274446_((Position)entity.m_20299_(1.0f));
        ThirdPersonConstants.SURROUNDINGS_MATCHING.rematch(center, (BlockGetter)entity.m_9236_(), s -> s.m_60831_((BlockGetter)entity.m_9236_(), center));
        int countT = ThirdPersonConstants.SURROUNDINGS_MATCHING.getMatches("T").count();
        int countM = ThirdPersonConstants.SURROUNDINGS_MATCHING.getMatches("M").count();
        isInNarrowSpace &= countT >= 3;
        return isInNarrowSpace &= countM >= 1;
    }
}

