/*
 * Decompiled with CFR 0.152.
 */
package com.github.leawind.thirdperson;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonEvents;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.github.leawind.thirdperson.config.Config;
import com.github.leawind.thirdperson.core.cameraoffset.CameraOffsetScheme;
import com.github.leawind.thirdperson.core.rotation.RotateTargetEnum;
import com.github.leawind.thirdperson.util.modkeymapping.ModKeyMapping;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

public final class ThirdPersonKeys {
    public static final ModKeyMapping ADJUST_POSITION = ModKeyMapping.of(ThirdPersonKeys.getId("adjust_position"), 90, "key.categories.leawind_third_person").onDown(ThirdPersonEvents::onStartAdjustingCameraOffset).onUp(ThirdPersonEvents::onStopAdjustingCameraOffset);
    public static final ModKeyMapping FORCE_AIMING = ModKeyMapping.of(ThirdPersonKeys.getId("force_aiming"), "key.categories.leawind_third_person");
    public static final ModKeyMapping TOGGLE_MOD_ENABLE = ModKeyMapping.of(ThirdPersonKeys.getId("toggle_mod_enable"), "key.categories.leawind_third_person").onDown(() -> {
        Config config = ThirdPerson.getConfig();
        if (ThirdPersonStatus.isRenderingInThirdPerson()) {
            if (config.is_mod_enabled) {
                ThirdPerson.ENTITY_AGENT.setRotateTarget(RotateTargetEnum.CAMERA_ROTATION);
            } else {
                Minecraft.m_91087_().f_91063_.m_109106_(null);
                ThirdPersonEvents.resetPlayer();
            }
            config.is_mod_enabled = !config.is_mod_enabled;
        }
    });
    public static final ModKeyMapping OPEN_CONFIG_MENU = ModKeyMapping.of(ThirdPersonKeys.getId("open_config_menu"), "key.categories.leawind_third_person").onDown(() -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            mc.m_91152_(ThirdPerson.CONFIG_MANAGER.getConfigScreen(null));
        }
    });
    public static final ModKeyMapping TOGGLE_SIDE = ModKeyMapping.of(ThirdPersonKeys.getId("toggle_side"), 280, "key.categories.leawind_third_person").onDown(() -> {
        CameraOffsetScheme scheme = ThirdPerson.getConfig().getCameraOffsetScheme();
        boolean wasCentered = scheme.isCentered();
        if (wasCentered) {
            scheme.toNextSide();
        }
        return wasCentered;
    }).onHold(() -> ThirdPerson.getConfig().getCameraOffsetScheme().setCentered(true)).onPress(() -> ThirdPerson.getConfig().getCameraOffsetScheme().toNextSide());
    public static final ModKeyMapping TOGGLE_AIMING = ModKeyMapping.of(ThirdPersonKeys.getId("toggle_aiming"), "key.categories.leawind_third_person").onDown(() -> {
        if (ThirdPerson.isAvailable() && ThirdPersonStatus.isRenderingInThirdPerson()) {
            ThirdPersonStatus.isToggleToAiming = !ThirdPersonStatus.isToggleToAiming;
        }
    });
    public static final ModKeyMapping TOGGLE_PITCH_LOCK = ModKeyMapping.of(ThirdPersonKeys.getId("toggle_pitch_lock"), "key.categories.leawind_third_person").onDown(() -> {
        Config config = ThirdPerson.getConfig();
        config.lock_camera_pitch_angle = !config.lock_camera_pitch_angle;
    });

    @NotNull
    private static String getId(@NotNull String name) {
        return "key.leawind_third_person." + name;
    }

    public static void register() {
        ModKeyMapping.registerAll();
    }
}

