/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.networking;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.networking.Message;
import com.klikli_dev.modonomicon.networking.SendAdvancementToClientMessage;
import com.klikli_dev.modonomicon.platform.Services;
import net.minecraft.advancements.Advancement;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class RequestAdvancementMessage
implements Message {
    public static final ResourceLocation ID = new ResourceLocation("modonomicon", "request_advancement");
    public ResourceLocation advancementId;

    public RequestAdvancementMessage(ResourceLocation advancementId) {
        this.advancementId = advancementId;
    }

    public RequestAdvancementMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.advancementId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.advancementId = buf.m_130281_();
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        Advancement adv = minecraftServer.m_129889_().m_136041_(this.advancementId);
        if (adv != null) {
            Services.NETWORK.sendTo(player, new SendAdvancementToClientMessage(this.advancementId, adv.m_138313_()));
        } else {
            Modonomicon.LOG.warn("Requested Advancement {} from server, but not found", (Object)this.advancementId);
        }
    }
}

