/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.network;

import java.util.function.Supplier;
import me.Thelnfamous1.bettermobcombat.network.BMCClientNetworkHandler;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.network.Packets;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public record S2CAttackAnimation(int mobId, AnimatedHand animatedHand, String animationName, float length, float upswing) {
    public static ResourceLocation ID = new ResourceLocation("bettermobcombat", "attack_animation");

    public static S2CAttackAnimation read(FriendlyByteBuf buffer) {
        int mobId = buffer.readInt();
        AnimatedHand animatedHand = AnimatedHand.values()[buffer.readInt()];
        String animationName = buffer.m_130277_();
        float length = buffer.readFloat();
        float upswing = buffer.readFloat();
        return new S2CAttackAnimation(mobId, animatedHand, animationName, length, upswing);
    }

    public static S2CAttackAnimation stop(int mobId, int length) {
        return new S2CAttackAnimation(mobId, AnimatedHand.MAIN_HAND, Packets.AttackAnimation.StopSymbol, length, 0.0f);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.mobId);
        buffer.writeInt(this.animatedHand.ordinal());
        buffer.m_130070_(this.animationName);
        buffer.writeFloat(this.length);
        buffer.writeFloat(this.upswing);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> BMCClientNetworkHandler.handleAttackAnimation(this.mobId(), this.animationName(), this.length(), this.animatedHand(), this.upswing()));
        ctx.get().setPacketHandled(true);
    }
}

