/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.mixin.compat.recruits;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.util.AttackUtil;
import me.Thelnfamous1.bettermobcombat.api.MobAttackWindup;
import me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.EntityPlayer_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={AttackUtil.class}, remap=false)
public abstract class AttackUtilMixin {
    @Inject(method={"checkAndPerformAttack"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void pre_checkAndPerformAttack(double distanceSqrToTarget, double reach, AbstractRecruitEntity recruit, LivingEntity target, CallbackInfo ci) {
        MobCombatHelper.onHoldingBetterCombatWeapon((Mob)recruit, (m, wa) -> {
            AttackHand currentAttack = ((EntityPlayer_BetterCombat)m).getCurrentAttack();
            if (currentAttack != null) {
                AttackUtilMixin.bettermobcombat$performBetterCombatAttack(recruit, target, wa, currentAttack);
                ci.cancel();
            }
        });
    }

    @Unique
    private static void bettermobcombat$performBetterCombatAttack(AbstractRecruitEntity recruit, LivingEntity target, WeaponAttributes wa, AttackHand currentAttack) {
        if (MobCombatHelper.isAttackReady((Mob)recruit) && MobCombatHelper.isWithinAttackRange((LivingEntity)recruit, (Entity)target, currentAttack.attack(), wa.attackRange())) {
            MobCombatHelper.setDelayedUpswing((Mob)recruit, () -> {
                ((MobAttackWindup)recruit).bettermobcombat$startUpswing(wa);
                recruit.attackCooldown = ((MobAttackWindup)recruit).bettermobcombat$getAttackCooldown();
            });
        }
    }

    @Inject(method={"performAttack"}, remap=false, at={@At(value="HEAD")}, cancellable=true)
    private static void pre_performAttack(AbstractRecruitEntity recruit, LivingEntity target, CallbackInfo ci) {
        if (AttackUtilMixin.bettermobcombat$useBetterCombatAttackCheck(recruit, target)) {
            ci.cancel();
        }
    }

    @Unique
    private static boolean bettermobcombat$useBetterCombatAttackCheck(AbstractRecruitEntity recruit, LivingEntity target) {
        return MobCombatHelper.canUseBetterCombatWeapon((Mob)recruit, (m, wa) -> {
            AttackHand currentAttack = ((EntityPlayer_BetterCombat)m).getCurrentAttack();
            if (currentAttack != null) {
                AttackUtilMixin.bettermobcombat$performBetterCombatAttack(recruit, target, wa, currentAttack);
                return true;
            }
            return false;
        });
    }
}

