/*
 * Decompiled with CFR 0.152.
 */
package me.Thelnfamous1.bettermobcombat.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.Thelnfamous1.bettermobcombat.Constants;
import me.Thelnfamous1.bettermobcombat.compatibility.BMCCompatibilityFlags;
import me.Thelnfamous1.bettermobcombat.compatibility.GeckolibHelper;
import me.Thelnfamous1.bettermobcombat.config.BMCServerConfig;
import net.bettercombat.logic.TargetHelper;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class BMCServerConfigHelper {
    public static final Codec<EntityType<?>> ENTITY_TYPE_CODEC = ResourceLocation.f_135803_.comapFlatMap(rl -> {
        if (BuiltInRegistries.f_256780_.m_7804_(rl)) {
            return DataResult.success((Object)((EntityType)BuiltInRegistries.f_256780_.m_7745_(rl)));
        }
        return DataResult.error(() -> String.format("Could not parse %s, not a valid entity type", rl));
    }, arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_256780_).m_7981_(arg_0));
    public static final Codec<TargetHelper.Relation> RELATION_CODEC = Codec.STRING.comapFlatMap(BMCServerConfigHelper::readRelation, Enum::name).stable();
    public static final Codec<Map<EntityType<?>, TargetHelper.Relation>> MOB_RELATIONS_CODEC = Codec.unboundedMap(ENTITY_TYPE_CODEC, RELATION_CODEC);
    public static final Codec<Map<String, TargetHelper.Relation>> MOB_RELATIONS_STRING_CODEC = Codec.unboundedMap((Codec)Codec.STRING, RELATION_CODEC);
    private final BMCServerConfig serverConfig;
    private final Set<EntityType<?>> mobBlacklist = new HashSet();
    private final Map<EntityType<?>, Map<EntityType<?>, TargetHelper.Relation>> mobRelations = new HashMap();
    private final Map<EntityType<?>, TargetHelper.Relation> mobRelationsToPassives = new HashMap();
    private final Map<EntityType<?>, TargetHelper.Relation> mobRelationsToHostiles = new HashMap();
    private final Map<EntityType<?>, TargetHelper.Relation> mobRelationsToOther = new HashMap();

    public BMCServerConfigHelper(BMCServerConfig serverConfig, boolean log) {
        this.serverConfig = serverConfig;
        for (String entry : serverConfig.mob_blacklist) {
            ResourceLocation id = ResourceLocation.m_135820_((String)entry);
            if (id == null) {
                if (!log) continue;
                Constants.LOG.error("Could not parse mob blacklist entry {}, not a valid namespaced id", (Object)entry);
                continue;
            }
            Optional entityType = BuiltInRegistries.f_256780_.m_6612_(id);
            entityType.ifPresentOrElse(et -> {
                this.mobBlacklist.add((EntityType<?>)et);
                if (log) {
                    Constants.LOG.debug("Entered {} into the mob blacklist!", (Object)id);
                }
            }, () -> {
                if (log) {
                    Constants.LOG.error("Could not find mob blacklist entry {}, not a valid entity type", (Object)id);
                }
            });
        }
        serverConfig.mob_relations.forEach((key, value) -> {
            EntityType entityType = ENTITY_TYPE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonPrimitive(key)).result().orElse(null);
            if (entityType == null) {
                if (log) {
                    Constants.LOG.error("Could not parse {} entry key {}, not a valid namespaced id", (Object)"mob_relations", key);
                }
                return;
            }
            Map modelModifier = MOB_RELATIONS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)new Gson().fromJson(value, JsonObject.class))).result().orElse(null);
            if (modelModifier == null) {
                if (log) {
                    Constants.LOG.error("Could not parse {} entry value {} mapped to {}, not a valid map of entity types to target relations", new Object[]{"mob_relations", key, value});
                }
                return;
            }
            if (log) {
                Constants.LOG.debug("Entered {}:{} into the mob_relations map!", key, value);
            }
            this.mobRelations.put(entityType, modelModifier);
        });
        BMCServerConfigHelper.parseMobRelations(serverConfig.mob_relations_to_passives, this.mobRelationsToPassives, "mob_relations_to_passives map", log);
        BMCServerConfigHelper.parseMobRelations(serverConfig.mob_relations_to_hostiles, this.mobRelationsToHostiles, "mob_relations_to_hostiles", log);
        BMCServerConfigHelper.parseMobRelations(serverConfig.mob_relations_to_other, this.mobRelationsToOther, "mob_relations_to_others", log);
    }

    private static DataResult<TargetHelper.Relation> readRelation(String relation) {
        try {
            return DataResult.success((Object)TargetHelper.Relation.valueOf((String)relation.toUpperCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Not a valid target relation: " + relation);
        }
    }

    private static void parseMobRelations(Map<String, TargetHelper.Relation> relationsToParse, Map<EntityType<?>, TargetHelper.Relation> mobRelationMap, String mapName, boolean log) {
        for (Map.Entry<String, TargetHelper.Relation> entry1 : relationsToParse.entrySet()) {
            ResourceLocation id1 = ResourceLocation.m_135820_((String)entry1.getKey());
            if (id1 == null) {
                if (!log) continue;
                Constants.LOG.error("Could not parse {} entry key {}, not a valid namespaced id", (Object)mapName, entry1);
                continue;
            }
            Optional entityTypeValue = BuiltInRegistries.f_256780_.m_6612_(id1);
            entityTypeValue.ifPresentOrElse(etv -> {
                mobRelationMap.put((EntityType<?>)etv, (TargetHelper.Relation)entry1.getValue());
                if (log) {
                    Constants.LOG.debug("Entered {}:{} into the {}!", new Object[]{id1, entry1.getValue(), mapName});
                }
            }, () -> {
                if (log) {
                    Constants.LOG.error("Could not find {} entry key {}, not a valid entity type", (Object)mapName, (Object)id1);
                }
            });
        }
    }

    public boolean isBlacklistedForBetterCombat(Entity entity) {
        if (this.serverConfig.geckolib_mobs_blacklisted && BMCCompatibilityFlags.isGeckolibLoaded() && GeckolibHelper.isGeoAnimatable(entity)) {
            return true;
        }
        if (this.serverConfig.mob_blacklist_as_whitelist) {
            return !this.mobBlacklist.contains(entity.m_6095_());
        }
        return this.mobBlacklist.contains(entity.m_6095_());
    }

    @Nullable
    public TargetHelper.Relation getMobRelation(EntityType<?> attackerType, EntityType<?> targetType) {
        Map<EntityType<?>, TargetHelper.Relation> relationsForMob = this.mobRelations.get(attackerType);
        if (relationsForMob == null) {
            return null;
        }
        return relationsForMob.get(targetType);
    }

    @Nullable
    public TargetHelper.Relation getMobRelationToPassives(EntityType<?> type) {
        return this.mobRelationsToPassives.get(type);
    }

    @Nullable
    public TargetHelper.Relation getMobRelationToHostiles(EntityType<?> type) {
        return this.mobRelationsToHostiles.get(type);
    }

    @Nullable
    public TargetHelper.Relation getMobRelationToOther(EntityType<?> type) {
        return this.mobRelationsToOther.get(type);
    }
}

