/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapConnectionNode {
    private final ResourceKey<Level> dimId;
    private final String mw;
    private String cachedString;

    public MapConnectionNode(ResourceKey<Level> dimId, String mw) {
        this.dimId = dimId;
        this.mw = mw;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.dimId.m_135782_().toString().replace(':', '$') + "/" + this.mw;
        }
        return this.cachedString;
    }

    public String getNamedString(MapWorld mapWorld) {
        MapDimension dim = mapWorld.getDimension(this.dimId);
        return this.dimId.m_135782_() + "/" + dim.getMultiworldName(this.mw);
    }

    public static MapConnectionNode fromString(String s) {
        ResourceLocation dimLocation;
        int dividerIndex = s.lastIndexOf(47);
        if (dividerIndex == -1) {
            return null;
        }
        String dimString = s.substring(0, dividerIndex);
        try {
            dimLocation = dimString.equals("0") ? Level.f_46428_.m_135782_() : (dimString.equals("-1") ? Level.f_46429_.m_135782_() : (dimString.equals("1") ? Level.f_46430_.m_135782_() : new ResourceLocation(dimString.replace('$', ':'))));
        }
        catch (Throwable t) {
            return null;
        }
        String mwString = s.substring(dividerIndex + 1);
        return new MapConnectionNode((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimLocation), mwString);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !(another instanceof MapConnectionNode)) {
            return false;
        }
        MapConnectionNode anotherNode = (MapConnectionNode)another;
        return this.dimId.equals(anotherNode.dimId) && this.mw.equals(anotherNode.mw);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public ResourceKey<Level> getDimId() {
        return this.dimId;
    }

    public String getMw() {
        return this.mw;
    }
}

