/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.optical_source.OpticalSourceBlock;
import net.lpcamors.optical.blocks.thermal_optical_source.ThermalOpticalSourceBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ThermalOpticalSourceRenderer
extends KineticBlockEntityRenderer<ThermalOpticalSourceBlockEntity> {
    public ThermalOpticalSourceRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(@NotNull ThermalOpticalSourceBlockEntity be) {
        return true;
    }

    protected void renderSafe(ThermalOpticalSourceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        this.renderFluid(be, partialTicks, ms, buffer, light);
        if (be.shouldRendererLaserBeam()) {
            IBeamSource.ClientSide.renderLaserBeam(be, be.m_58900_(), ms, buffer);
        }
    }

    protected void renderFluid(ThermalOpticalSourceBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            float yMin = 0.063125f;
            float min = 0.063125f;
            float max = 0.936875f;
            float yOffset = yMin + 0.498125f * level;
            ms.m_85836_();
            ms.m_252880_(0.0f, yOffset, 0.0f);
            ms.m_85849_();
        }
    }

    public boolean shouldRender(ThermalOpticalSourceBlockEntity be, Vec3 vec) {
        return true;
    }

    public int m_142163_() {
        return 256;
    }

    protected SuperByteBuffer getRotatedModel(ThermalOpticalSourceBlockEntity be, BlockState state) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)((Direction)state.m_61143_(OpticalSourceBlock.HORIZONTAL_FACING)).m_122424_());
    }
}

