/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.beam_condenser;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.createmod.catnip.lang.Lang;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.beam_condenser.BeamCondenserBlock;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeamCondenserBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IBeamSource {
    private Map<Direction, IBeamReceiver.BeamSourceInstance> beamSourceInstanceMap = BeamCondenserBlockEntity.emptyMap();
    private Map<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties> beamPropertiesMap = new HashMap<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties>();
    private List<BlockPos> iBeamReceiverBlockPos = new ArrayList<BlockPos>();
    private List<BlockPos> toIBeamReceiverBlockPos = new ArrayList<BlockPos>();
    private int tickCount = 0;
    private BeamHelper.BeamProperties initialBeamProperties;

    private static Map<Direction, IBeamReceiver.BeamSourceInstance> emptyMap() {
        HashMap<Direction, IBeamReceiver.BeamSourceInstance> map = new HashMap<Direction, IBeamReceiver.BeamSourceInstance>();
        IBeamReceiver.BeamSourceInstance empty = IBeamReceiver.BeamSourceInstance.empty(null);
        for (Direction direction : Direction.values()) {
            map.put(direction, empty);
        }
        return map;
    }

    public BeamCondenserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        ++this.tickCount;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean f = false;
            for (Direction direction : Direction.values()) {
                if (!this.shouldUpdate(direction)) continue;
                f = true;
            }
            if (f) {
                this.update();
            }
        }
        this.toIBeamReceiverBlockPos = new ArrayList<BlockPos>();
        this.beamPropertiesMap.clear();
        if (this.getInitialBeamProperties() != null && this.getInitialBeamProperties().intensity > 0.0f) {
            IBeamSource.propagateLinearBeamVar(this, this.m_58899_(), this.getInitialBeamProperties(), 0);
        }
        this.iBeamReceiverBlockPos = this.toIBeamReceiverBlockPos;
    }

    public void update() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.initialBeamProperties = this.getResultantBeamProperties((Direction)this.m_58900_().m_61143_((Property)BeamCondenserBlock.f_54117_));
        this.m_6596_();
        this.sendData();
    }

    public boolean shouldUpdate(Direction direction) {
        IBeamReceiver.BeamSourceInstance beamSourceInstance = this.beamSourceInstanceMap.get(direction);
        this.beamSourceInstanceMap.put(direction, beamSourceInstance.checkSourceExistenceAndCompatibility((BlockEntity)this));
        this.m_6596_();
        return !beamSourceInstance.equals(this.beamSourceInstanceMap.get(direction));
    }

    public boolean changeState(Direction direction, BlockPos pos, BeamHelper.BeamProperties beamProperties) {
        if (this.beamSourceInstanceMap.get(direction).optionalBeamProperties().isEmpty()) {
            this.beamSourceInstanceMap.put(direction, new IBeamReceiver.BeamSourceInstance(Optional.of(beamProperties), pos));
            this.update();
            return true;
        }
        return beamProperties.equals(this.beamSourceInstanceMap.get(direction).optionalBeamProperties().orElse(null));
    }

    @Nullable
    public BeamHelper.BeamProperties getResultantBeamProperties(Direction direction) {
        ArrayList beamProperties = new ArrayList();
        this.beamSourceInstanceMap.keySet().stream().map(direction1 -> this.beamSourceInstanceMap.get(direction1)).forEach(beamSourceInstance -> beamSourceInstance.optionalBeamProperties().ifPresent(beamProperties::add));
        if (beamProperties.isEmpty()) {
            return null;
        }
        return BeamHelper.BeamProperties.sum(direction, beamProperties.stream().toList());
    }

    @Override
    @Nullable
    public BeamHelper.BeamProperties getInitialBeamProperties() {
        return this.initialBeamProperties;
    }

    @Override
    public void addToBeamBlocks(Vec3i vec, Vec3i vec1, BeamHelper.BeamProperties beamProperties) {
        this.beamPropertiesMap.put((Pair<Vec3i, Vec3i>)new Pair((Object)vec, (Object)vec1), beamProperties);
    }

    @Override
    public Map<Pair<Vec3i, Vec3i>, BeamHelper.BeamProperties> getBeamPropertiesMap() {
        return this.beamPropertiesMap;
    }

    @Override
    public boolean isDependent(BlockPos pos) {
        return this.iBeamReceiverBlockPos.contains(pos);
    }

    @Override
    public void addDependent(BlockPos pos) {
        this.toIBeamReceiverBlockPos.add(pos);
    }

    @Override
    public int getTickCount() {
        return this.tickCount;
    }

    @Override
    public boolean shouldRendererLaserBeam() {
        return this.getInitialBeamProperties() != null && this.getInitialBeamProperties().intensity != 0.0f && this.getInitialBeamProperties().isVisible() && !this.getBeamPropertiesMap().keySet().isEmpty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        ListTag listTag = new ListTag();
        this.iBeamReceiverBlockPos.forEach(pos -> listTag.add((Object)NbtUtils.m_129224_((BlockPos)pos)));
        ListTag listTag1 = new ListTag();
        Arrays.stream(Direction.values()).forEach(direction -> {
            CompoundTag tag = new CompoundTag();
            this.beamSourceInstanceMap.get(direction).write(tag);
            listTag1.add((Object)tag);
        });
        compound.m_128365_("IBeamReceiverBlockPosList", (Tag)listTag);
        compound.m_128365_("IBeamSourceMap", (Tag)listTag1);
        if (this.initialBeamProperties != null) {
            this.initialBeamProperties.write(compound);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        ListTag listTag;
        super.read(compound, clientPacket);
        if (compound.m_128441_("IBeamReceiverBlockPosList") && (listTag = (ListTag)compound.m_128423_("IBeamReceiverBlockPosList")) != null) {
            listTag.forEach(tag -> this.iBeamReceiverBlockPos.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag))));
        }
        BeamHelper.BeamProperties.read(compound).ifPresent(beamProperties -> {
            this.initialBeamProperties = beamProperties;
        });
        if (compound.m_128441_("IBeamSourceMap") && (listTag = (ListTag)compound.m_128423_("IBeamSourceMap")) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                this.beamSourceInstanceMap.put(Direction.values()[i], IBeamReceiver.BeamSourceInstance.read((CompoundTag)listTag.get(i)));
            }
        }
        if (!clientPacket) {
            return;
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BeamHelper.BeamProperties beamProperties = this.getResultantBeamProperties((Direction)this.m_58900_().m_61143_((Property)BeamCondenserBlock.f_54117_));
        if (beamProperties == null) {
            return false;
        }
        Lang.builder((String)"tooltip").translate("create_optical.gui.goggles.beam_properties", new Object[0]).forGoggles(tooltip);
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.beam_type", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate(beamProperties.beamType.getDescriptionId(), new Object[0]).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.propagation_range", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.builder((String)"").add(Component.m_237113_((String)(" " + beamProperties.beamType.getRange() + " blocks")).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        BeamHelper.BeamPolarization beamPolarization = beamProperties.beamPolarization;
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.polarization", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.builder((String)"").add(COLang.Prefixes.CREATE.translate(beamPolarization.getDescriptionId(), new Object[0]).m_130946_(" " + beamPolarization.getsIcon()).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        return true;
    }
}

