/*
 * Decompiled with CFR 0.152.
 */
package smartin.bc_nbt_fix;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.bettercombat.api.AttributesContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import smartin.bc_nbt_fix.mixin.WeaponRegistryAccessor;

public class SyncPacket {
    public static void decodeRegistry(FriendlyByteBuf buffer) {
        int totalChunkCount = buffer.readInt();
        StringBuilder jsonBuilder = new StringBuilder();
        for (int i = 0; i < totalChunkCount; ++i) {
            jsonBuilder.append(buffer.m_130277_());
        }
        Gson gson = new Gson();
        Type attributeContainerType = new TypeToken<Map<String, AttributesContainer>>(){}.getType();
        Map readAttributes = (Map)gson.fromJson(jsonBuilder.toString(), attributeContainerType);
        HashMap<ResourceLocation, AttributesContainer> newAttributes = new HashMap<ResourceLocation, AttributesContainer>();
        readAttributes.forEach((key, value) -> newAttributes.put(new ResourceLocation(key), (AttributesContainer)value));
        WeaponRegistryAccessor.setContainers(newAttributes);
    }

    public static void appendBufferData(FriendlyByteBuf buffer) {
        Gson gson = new Gson();
        String json = gson.toJson(WeaponRegistryAccessor.getContainers());
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        buffer.writeInt(chunks.size());
        for (String chunk : chunks) {
            buffer.m_130070_(chunk);
        }
    }
}

