/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ModConfigs {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> VOLUME;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LINKED_TO_MUSIC;
    public static final ForgeConfigSpec.ConfigValue<Double> HEALTH_PITCH_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Double> PHASE2_PITCH_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<Integer> HEALTH_PITCH_THRESH;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HEALTH_PITCH_PERCENT;
    public static final ForgeConfigSpec.ConfigValue<Double> FADE_TIME;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITIES_SONGS;
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_SONG;

    static {
        BUILDER.push("battlemusic configs");
        VOLUME = BUILDER.comment("Volume of battle music, set to zero to mute").defineInRange("volume", 1.0, 0.0, 5.0);
        LINKED_TO_MUSIC = BUILDER.comment("\nWhether battle music's volume is affected by the music slider").define("linked_to_music_volume", true);
        HEALTH_PITCH_AMOUNT = BUILDER.comment("\nHow much the battle music changes in pitch when at low health    \n    > Values below zero shift the pitch down, above zero shift the pitch up    \n    > Set to zero to disable   ").defineInRange("health_pitch_amount", 0.05, -0.5, 1.0);
        PHASE2_PITCH_AMOUNT = BUILDER.comment("\nHow much the battle music changes in pitch during the second phases of the Ender Dragon and Wither fights    \n    > Values below zero shift the pitch down, above zero shift the pitch up  \n    > Set to zero to disable     ").defineInRange("phase2_pitch_amount", 0.05, -0.5, 1.0);
        HEALTH_PITCH_THRESH = BUILDER.comment("\nAt what HP should the battle music shift in pitch").defineInRange("health_pitch_thresh", 6, 1, Integer.MAX_VALUE);
        HEALTH_PITCH_PERCENT = BUILDER.comment("\nIs the health threshold a percentage value?    \n    > If it is, the above value must be between 1 and 100    ").define("health_pitch_percent", false);
        FADE_TIME = BUILDER.comment("\nHow many seconds songs take to fade in and out").defineInRange("fade_time", 1.0, 0.0, 10.0);
        ENTITIES_SONGS = BUILDER.comment("\nEntites and their respective songs, write in entity;song;priority format       \n    > entity = the entity's ID, eg. \"minecraft:pig\"       \n    > song = the song's ID, eg. \"battlemusic:mini1\"       \n    > priority = what precedence this song takes over other entity's music, eg. a priority of 1 will fade out and play over a priority of 0.      ").defineListAllowEmpty(List.of("entities_songs"), () -> List.of("minecraft:elder_guardian;battlemusic:mini1;0", "minecraft:warden;battlemusic:necromancer;1", "minecraft:wither;battlemusic:wither_storm;2", "minecraft:ender_dragon;battlemusic:enderman;5", "queen_bee:queen_bee;battlemusic:mini1;0", "irons_spellbooks:dead_king;battlemusic:boss;2", "irons_spellbooks:citadel_keeper;battlemusic:mini1;0", "irons_spellbooks:archevoker;battlemusic:mini1;0", "dawnera:tyrannosaurus;battlemusic:mini1;0", "upgrade_aquatic:great_thrasher;battlemusic:mini1;0", "born_in_chaos_v1:dire_hound_leader;battlemusic:mini1;0", "born_in_chaos_v1:supreme_bonescaller;battlemusic:mini1;0", "born_in_chaos_v1:lord_pumpkinhead;battlemusic:mini2;0", "alexscaves:luxtructosaurus;battlemusic:porcus_humungous;5", "alexscaves:tremorzilla;battlemusic:metaluna;2", "alexscaves:magnetron;battlemusic:mini2;0", "alexscaves:forsaken;battlemusic:mini2;1", "alexscaves:brainiac;battlemusic:mini1;0", "alexsmobs:void_worm;battlemusic:ghast;4", "alexsmobs:warped_mosco;battlemusic:mini1;0", "endergetic:brood_eetle;battlemusic:cauldron;2", "aether:slider;battlemusic:mini2;2", "aether:valkyrie;battlemusic:mini1;0", "aether:sun_spirit;battlemusic:summit;3", "aether:valkyrie_queen;battlemusic:mini2;2", "cataclysm:ender_golem;battlemusic:mini2;0", "cataclysm:ignited_revenant;battlemusic:mini2;0", "cataclysm:ignited_berserker;battlemusic:mini2;0", "cataclysm:ender_guardian;battlemusic:menta_menardi;4", "cataclysm:netherite_monstrosity;battlemusic:redstone_monstrosity;4", "cataclysm:ignis;battlemusic:wildfire;4", "cataclysm:the_harbinger;battlemusic:ancient;4", "cataclysm:the_leviathan;battlemusic:ancient_guardian;4", "cataclysm:the_prowler;battlemusic:mini1;0", "cataclysm:amethyst_crab;battlemusic:mini2;0", "cataclysm:coralssus;battlemusic:mini1;0", "cataclysm:ancient_remnant;battlemusic:ascension;3", "cataclysm:deepling_brute;battlemusic:mini1;0", "mowziesmobs:ferrous_wroughtnaut;mowziesmobs:music.ferrous_wroughtnaut_theme;1", "mowziesmobs:umvuthi;mowziesmobs:music.umvuthi_theme;2", "mowziesmobs:frostmaw;mowziesmobs:music.frostmaw_theme;2", "bosses_of_mass_destruction:void_blossom;battlemusic:arena2;1", "bosses_of_mass_destruction:lich;battlemusic:boss;2", "bosses_of_mass_destruction:gauntlet;battlemusic:kermetic;3", "bosses_of_mass_destruction:obsidilith;battlemusic:broken_heart_of_ender;3", "twilightforest:naga;battlemusic:arena2;2", "twilightforest:lich;battlemusic:boss;3", "twilightforest:hydra;battlemusic:arena1;3", "twilightforest:minoshroom;battlemusic:mini1;0", "twilightforest:alpha_yeti;battlemusic:mini2;1", "twilightforest:phantom_knight;battlemusic:mini2;1", "twilightforest:ur_ghast;battlemusic:metaluna;3", "twilightforest:snow_queen;battlemusic:ascension;3", "mutantmonsters:mutant_zombie;battlemusic:mini1;0", "mutantmonsters:mutant_skeleton;battlemusic:mini1;0", "mutantmonsters:mutant_creeper;battlemusic:mini2;0", "mutantmonsters:mutant_enderman;battlemusic:shattered;1"), a -> true);
        DEFAULT_SONG = BUILDER.comment("\nA generic battle song to play for any other undefined hostile entity      \n    > Leave blank for no default battle music       ").define("default_song", (Object)"");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

