/*
 * Decompiled with CFR 0.152.
 */
package com.nekotune.battlemusic;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.nekotune.battlemusic.BattleMusic;
import com.nekotune.battlemusic.ModConfigs;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class ModCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"battlemusic").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"volume").then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)5.0f)).executes(ModCommands::setVolume)))).then(Commands.m_82127_((String)"get").executes(ModCommands::getVolume))).then(Commands.m_82127_((String)"separate").then(Commands.m_82129_((String)"separate", (ArgumentType)BoolArgumentType.bool()).executes(ModCommands::separateVolume))))).then(Commands.m_82127_((String)"reload").executes(ModCommands::reload))).then(Commands.m_82127_((String)"debug").executes(ModCommands::debug))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121645_).executes(ctx -> ModCommands.set((CommandContext<CommandSourceStack>)ctx, false, false))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"song", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121643_).executes(ctx -> ModCommands.set((CommandContext<CommandSourceStack>)ctx, true, false))).then(Commands.m_82129_((String)"priority", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ModCommands.set((CommandContext<CommandSourceStack>)ctx, true, true))))));
        dispatcher.register(builder);
    }

    private static int setVolume(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        float volume = ((Float)context.getArgument("volume", Float.TYPE)).floatValue();
        ModConfigs.VOLUME.set((Object)volume);
        ModConfigs.VOLUME.save();
        BattleMusic.setVolume(volume);
        source.m_288197_(() -> Component.m_237113_((String)("Set battle music volume to " + volume)), true);
        return 1;
    }

    private static int getVolume(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)("Battle music volume is currently set to " + ModConfigs.VOLUME.get())), true);
        return 1;
    }

    private static int separateVolume(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean separate = (Boolean)context.getArgument("separate", Boolean.TYPE);
        ModConfigs.LINKED_TO_MUSIC.set((Object)separate);
        ModConfigs.LINKED_TO_MUSIC.save();
        source.m_288197_(() -> Component.m_237113_((String)(separate ? "Battle music volume is now separate from music volume" : "Battle music volume is now linked to music volume")), true);
        return 1;
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_288197_(() -> Component.m_237113_((String)"Reloaded battle music"), true);
        BattleMusic.reload();
        return 1;
    }

    private static int debug(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        BattleMusic.LOGGER.debug("BATTLE MUSIC DEBUG INFO\n  - Is sound playing? {}\n  - Entity playing music: {}\n  - Sound being played: {}\n  - Volume: {}\n  - Pitch: {}\n  - Fading out? {}\n  - Priority: {}", new Object[]{BattleMusic.playing != null ? Boolean.valueOf(Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)BattleMusic.playing)) : "false", BattleMusic.playing != null ? BattleMusic.playing.entity.m_7755_().getString() : "NULL", BattleMusic.playing != null ? BattleMusic.playing.soundEvent.m_11660_() : "NULL", BattleMusic.playing != null ? Float.valueOf(BattleMusic.playing.m_7769_()) : "0", BattleMusic.playing != null ? Float.valueOf(BattleMusic.playing.m_7783_()) : "1", BattleMusic.playing != null && BattleMusic.playing.fadeOut, BattleMusic.playing != null ? Integer.valueOf(BattleMusic.playing.priority) : "0"});
        source.m_288197_(() -> Component.m_237113_((String)"Logged debug info to logs/debug.log"), true);
        return 1;
    }

    private static int set(CommandContext<CommandSourceStack> context, boolean songDef, boolean priorityDef) {
        String success;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceLocation entity = (ResourceLocation)context.getArgument("entity", ResourceLocation.class);
        ArrayList<CallSite> data = new ArrayList<CallSite>((Collection)ModConfigs.ENTITIES_SONGS.get());
        int priority = 0;
        boolean changes = false;
        for (int i = 0; i < data.size(); ++i) {
            String item = (String)data.get(i);
            if (!item.substring(0, item.indexOf(59)).equalsIgnoreCase(entity.toString())) continue;
            priority = Integer.parseInt(item.substring(item.lastIndexOf(59) + 1));
            data.remove(i);
            changes = true;
            --i;
        }
        if (songDef) {
            ResourceLocation song = (ResourceLocation)context.getArgument("song", ResourceLocation.class);
            if (priorityDef) {
                priority = (Integer)context.getArgument("priority", Integer.TYPE);
            }
            data.add((CallSite)((Object)(entity.toString() + ";" + song.toString() + ";" + priority)));
            ModConfigs.ENTITIES_SONGS.set(data);
            ModConfigs.ENTITIES_SONGS.save();
            success = "Set battle music for entity " + entity.m_135815_() + " to sound " + song + " with priority " + priority;
        } else if (changes) {
            ModConfigs.ENTITIES_SONGS.set(data);
            ModConfigs.ENTITIES_SONGS.save();
            success = "Removed battle music from entity " + entity.m_135815_();
        } else {
            source.m_81352_((Component)Component.m_237113_((String)("No battle music set for entity " + entity.m_135815_())));
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)success), true);
        BattleMusic.reload();
        return 1;
    }
}

