/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.plating;

import com.min01.gravityapi.EntityTags;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.capabilities.GravityCapabilityImpl;
import com.min01.gravityapi.config.GravityConfig;
import com.min01.gravityapi.init.GravityBlocks;
import com.min01.gravityapi.plating.GravityPlatingBlock;
import com.min01.gravityapi.plating.GravityPlatingItem;
import com.min01.gravityapi.util.GCUtil;
import com.min01.gravityapi.util.RotationUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class GravityPlatingBlockEntity
extends BlockEntity {
    private static final int MAX_LEVEL = 64;
    @Nullable
    private SideData[] sideData = null;
    @Nullable
    private AABB roughAreaBoxCache = null;

    public GravityPlatingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GravityBlocks.GRAVITY_PLATING_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.sideData = new SideData[6];
        for (Direction dir : Direction.values()) {
            String dirName = dir.m_122433_();
            if (!tag.m_128441_(dirName)) continue;
            CompoundTag sideTag = tag.m_128469_(dirName);
            this.sideData[dir.ordinal()] = SideData.fromTag(sideTag);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.sideData != null) {
            for (Direction dir : Direction.values()) {
                String dirName = dir.m_122433_();
                SideData side = this.sideData[dir.ordinal()];
                if (side == null) continue;
                tag.m_128365_(dirName, (Tag)side.toTag());
            }
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void refreshCache() {
        Level world = this.m_58904_();
        if (world == null) {
            return;
        }
        if (this.sideData == null) {
            this.sideData = new SideData[6];
        }
        BlockState blockState = world.m_8055_(this.m_58899_());
        for (Direction direction : Direction.values()) {
            if (GravityPlatingBlock.hasDir(blockState, direction)) {
                if (this.sideData[direction.ordinal()] != null) continue;
                this.sideData[direction.ordinal()] = SideData.createDefault();
                continue;
            }
            this.sideData[direction.ordinal()] = null;
        }
        if ((long)(this.f_58858_.hashCode() % 5) == world.m_46467_() % 5L) {
            this.roughAreaBoxCache = null;
            for (SideData sideData : this.sideData) {
                if (sideData == null) continue;
                sideData.effectBoxCache = null;
            }
        }
    }

    private AABB getRoughEffectBox() {
        if (this.roughAreaBoxCache == null) {
            double maxRange = 0.0;
            for (SideData sideDatum : this.sideData) {
                if (sideDatum == null) continue;
                maxRange = Math.max(maxRange, sideDatum.getEffectRange());
            }
            BlockPos blockPos = this.m_58899_();
            double expand = 0.001;
            double delta = maxRange + expand;
            return new AABB((double)blockPos.m_123341_() - delta, (double)blockPos.m_123342_() - delta, (double)blockPos.m_123343_() - delta, (double)(blockPos.m_123341_() + 1) + delta, (double)(blockPos.m_123342_() + 1) + delta, (double)(blockPos.m_123343_() + 1) + delta);
        }
        return this.roughAreaBoxCache;
    }

    public static void tick(Level world, BlockPos blockPos, BlockState blockState, GravityPlatingBlockEntity be) {
        Block block = blockState.m_60734_();
        if (!(block instanceof GravityPlatingBlock)) {
            return;
        }
        GravityPlatingBlock gravityPlatingBlock = (GravityPlatingBlock)block;
        be.refreshCache();
        AABB roughBox = be.getRoughEffectBox();
        List entities = world.m_6443_(Entity.class, roughBox, e -> EntityTags.canChangeGravity(e));
        for (Entity entity : entities) {
            boolean applies = false;
            GravityCapabilityImpl comp = GravityChangerAPI.getGravityComponent(entity);
            Direction entityGravityDir = comp.getCurrGravityDirection();
            for (Direction plateDir : Direction.values()) {
                double adjustment;
                SideData sideDatum = be.sideData[plateDir.ordinal()];
                if (sideDatum == null) continue;
                Direction gravityEffectDir = sideDatum.isAttracting ? plateDir : plateDir.m_122424_();
                boolean isOpposite = entityGravityDir == gravityEffectDir.m_122424_();
                Vec3 testingPos = isOpposite ? entity.m_146892_() : entity.m_20182_();
                AABB gravityEffectBox = sideDatum.getEffectBox(blockPos, plateDir, world);
                if (!gravityEffectBox.m_82390_(testingPos)) continue;
                Vec3 plateDirVec = Vec3.m_82528_((Vec3i)plateDir.m_122436_());
                Vec3 effectCenter = Vec3.m_82512_((Vec3i)blockPos).m_82549_(plateDirVec.m_82490_(0.5));
                Vec3 effectCenterAdjusted = effectCenter.m_82549_(plateDirVec.m_82490_(-(adjustment = 0.1)));
                Vec3 deltaVec = testingPos.m_82546_(effectCenterAdjusted);
                double distanceToPlane = -deltaVec.m_82526_(plateDirVec);
                if (distanceToPlane < -adjustment - 0.001) continue;
                Vec3 localVec = RotationUtil.vecWorldToPlayer(deltaVec, plateDir);
                double dx = GCUtil.distanceToRange(localVec.f_82479_, -0.5, 0.5);
                double dz = GCUtil.distanceToRange(localVec.f_82481_, -0.5, 0.5);
                double distanceToPlate = Math.sqrt(dx * dx + dz * dz + distanceToPlane * distanceToPlane);
                double priority = 1000.0 - distanceToPlate;
                if (isOpposite) {
                    priority -= 10.0;
                }
                comp.applyGravityDirectionEffect(gravityEffectDir, null, priority);
                applies = true;
            }
            if (!applies || !((Boolean)GravityConfig.autoJumpOnGravityPlateInnerCorner.get()).booleanValue()) continue;
            GravityPlatingBlockEntity.tryToDoCornerAutoJump(blockState, blockPos, entity, comp);
        }
    }

    private static void tryToDoCornerAutoJump(BlockState blockState, BlockPos blockPos, Entity entity, GravityCapabilityImpl comp) {
        if (!entity.m_20096_()) {
            return;
        }
        Direction entityGravityDir = comp.getCurrGravityDirection();
        for (Direction plateDir : Direction.values()) {
            double distanceToPlate;
            Vec3 worldVelocity;
            boolean orthogonal;
            if (!GravityPlatingBlock.hasDir(blockState, plateDir)) continue;
            boolean bl = orthogonal = entityGravityDir.m_122434_() != plateDir.m_122434_();
            if (!orthogonal) continue;
            Vec3 plateDirVec = Vec3.m_82528_((Vec3i)plateDir.m_122436_());
            Vec3 effectCenter = Vec3.m_82512_((Vec3i)blockPos).m_82549_(plateDirVec.m_82490_(0.5));
            Vec3 offset = effectCenter.m_82546_(entity.m_20182_());
            if (offset.m_82526_(Vec3.m_82528_((Vec3i)entityGravityDir.m_122436_())) > 0.0 || (worldVelocity = GravityChangerAPI.getWorldVelocity(entity)).m_82526_(plateDirVec) < 0.01 || !((distanceToPlate = Math.abs(entity.m_20182_().m_82546_(effectCenter).m_82526_(plateDirVec))) < 0.8)) continue;
            double strengthSqrt = Math.sqrt(comp.getCurrGravityStrength());
            Vec3 entityGravityVec = Vec3.m_82528_((Vec3i)entityGravityDir.m_122436_());
            Vec3 deltaWorldVelocity = entityGravityVec.m_82490_(-strengthSqrt * 0.4).m_82549_(plateDirVec.m_82490_(0.08));
            GravityChangerAPI.setWorldVelocity(entity, GravityChangerAPI.getWorldVelocity(entity).m_82549_(deltaWorldVelocity));
            if (entity.m_9236_().m_5776_()) {
                // empty if block
            }
            return;
        }
    }

    public InteractionResult interact(Level level, BlockPos pos, Direction plateDir, Player player, InteractionHand hand) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        this.refreshCache();
        SideData sideDatum = this.sideData[plateDir.ordinal()];
        if (sideDatum == null) {
            return InteractionResult.FAIL;
        }
        ItemStack handItem = player.m_21120_(hand);
        if (handItem.m_41720_() == Items.f_41852_) {
            if (sideDatum.level != 1) {
                --sideDatum.level;
                if (!player.m_7500_()) {
                    player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_151086_));
                }
            } else {
                sideDatum.isAttracting = !sideDatum.isAttracting;
            }
        } else if (handItem.m_41720_() == Items.f_151086_) {
            if (!player.m_7500_()) {
                handItem.m_41774_(1);
            }
            ++sideDatum.level;
            if (sideDatum.level > 64) {
                sideDatum.level = 64;
            }
        } else {
            ((ServerPlayer)player).m_240418_((Component)Component.m_237115_((String)"gravity_changer.plate.wrong_interaction"), true);
            return InteractionResult.FAIL;
        }
        this.sync();
        boolean isAttracting = sideDatum.isAttracting;
        ((ServerPlayer)player).m_240418_((Component)Component.m_237110_((String)"gravity_changer.plate.status", (Object[])new Object[]{GCUtil.getDirectionText(plateDir.m_122424_()), sideDatum.level, GravityPlatingBlockEntity.getForceText(isAttracting)}), true);
        return InteractionResult.SUCCESS;
    }

    public static MutableComponent getForceText(boolean isAttracting) {
        return Component.m_237115_((String)(isAttracting ? "gravity_changer.plate.force.attract" : "gravity_changer.plate.force.repulse"));
    }

    public void sync() {
        Level world = this.m_58904_();
        Validate.notNull((Object)world);
        Validate.isTrue((!world.m_5776_() ? 1 : 0) != 0);
        this.m_6596_();
        ((ServerChunkCache)world.m_7726_()).m_8450_(this.m_58899_());
    }

    public void onPlacing(Direction side, SideData sideData) {
        this.refreshCache();
        this.sideData[side.ordinal()] = sideData;
        this.sync();
    }

    public List<ItemStack> getDrops() {
        if (this.sideData == null) {
            return List.of();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Direction value : Direction.values()) {
            SideData sideDatum = this.sideData[value.ordinal()];
            if (sideDatum == null) continue;
            ItemStack stack = GravityPlatingItem.createStack(sideDatum);
            drops.add(stack);
        }
        return drops;
    }

    public static class SideData {
        public boolean isAttracting = true;
        public int level = 1;
        @Nullable
        public AABB effectBoxCache = null;

        public SideData(boolean isAttracting, int level) {
            this.isAttracting = isAttracting;
            this.level = level;
        }

        public static SideData createDefault() {
            return new SideData(true, 1);
        }

        public static SideData fromTag(CompoundTag tag) {
            boolean isAttracting_ = tag.m_128471_("isAttracting");
            int level_ = tag.m_128451_("level");
            level_ = Mth.m_14045_((int)level_, (int)1, (int)64);
            return new SideData(isAttracting_, level_);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isAttracting", this.isAttracting);
            tag.m_128405_("level", this.level);
            return tag;
        }

        public double getEffectRange() {
            return (double)this.level - 0.1;
        }

        public AABB getEffectBox(BlockPos blockPos, Direction plateDir, Level world) {
            if (this.effectBoxCache == null) {
                double expand = 0.001;
                double minX = (double)blockPos.m_123341_() - expand;
                double minY = (double)blockPos.m_123342_() - expand;
                double minZ = (double)blockPos.m_123343_() - expand;
                double maxX = (double)(blockPos.m_123341_() + 1) + expand;
                double maxY = (double)(blockPos.m_123342_() + 1) + expand;
                double maxZ = (double)(blockPos.m_123343_() + 1) + expand;
                double delta = this.getEffectRange() - 1.0;
                switch (plateDir) {
                    case DOWN: {
                        maxY += delta;
                        break;
                    }
                    case UP: {
                        minY -= delta;
                        break;
                    }
                    case NORTH: {
                        maxZ += delta;
                        break;
                    }
                    case SOUTH: {
                        minZ -= delta;
                        break;
                    }
                    case WEST: {
                        maxX += delta;
                        break;
                    }
                    case EAST: {
                        minX -= delta;
                    }
                }
                BlockPos wallPos = blockPos.m_121945_(plateDir);
                block16: for (Direction sideDir : Direction.values()) {
                    BlockEntity blockEntity;
                    BlockPos sidePos;
                    BlockState sideBlockState;
                    Block block;
                    if (sideDir.m_122434_() == plateDir.m_122434_() || !((block = (sideBlockState = world.m_8055_(sidePos = wallPos.m_121945_(sideDir))).m_60734_()) instanceof GravityPlatingBlock)) continue;
                    GravityPlatingBlock sidePlatingBlock = (GravityPlatingBlock)block;
                    if (!GravityPlatingBlock.hasDir(sideBlockState, sideDir.m_122424_()) || !((blockEntity = world.m_7702_(sidePos)) instanceof GravityPlatingBlockEntity)) continue;
                    GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
                    if (this.isAttracting != this.isAttracting) continue;
                    double sideDelta = this.getEffectRange();
                    switch (sideDir) {
                        case DOWN: {
                            minY -= sideDelta;
                            continue block16;
                        }
                        case UP: {
                            maxY += sideDelta;
                            continue block16;
                        }
                        case NORTH: {
                            minZ -= sideDelta;
                            continue block16;
                        }
                        case SOUTH: {
                            maxZ += sideDelta;
                            continue block16;
                        }
                        case WEST: {
                            minX -= sideDelta;
                            continue block16;
                        }
                        case EAST: {
                            maxX += sideDelta;
                        }
                    }
                }
                this.effectBoxCache = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
            }
            return this.effectBoxCache;
        }
    }
}

