/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.plating;

import com.google.common.collect.ImmutableMap;
import com.min01.gravityapi.init.GravityBlocks;
import com.min01.gravityapi.plating.GravityPlatingBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GravityPlatingBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesByState;

    public GravityPlatingBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60910_().m_60966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
        this.shapesByState = ImmutableMap.copyOf(this.f_49792_.m_61056_().stream().collect(Collectors.toMap(Function.identity(), GravityPlatingBlock::getShapeForState)));
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            voxelShape = UP_SHAPE;
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)NORTH_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)WEST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)EAST_SHAPE);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)DOWN_SHAPE);
        }
        return voxelShape.m_83281_() ? Shapes.m_83144_() : voxelShape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapesByState.get(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (GravityPlatingBlock.hasDir(state, direction) && !this.canPlaceOn((BlockGetter)world, pos.m_121945_(direction), direction.m_122424_())) {
            if (GravityPlatingBlock.getDirections(state = (BlockState)state.m_61124_((Property)GravityPlatingBlock.directionToProperty(direction), (Comparable)Boolean.valueOf(false))).size() == 0) {
                return Blocks.f_50016_.m_49966_();
            }
            return state;
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GravityPlatingBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        if (world.f_46443_) {
            return GravityPlatingBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)GravityBlocks.GRAVITY_PLATING_BLOCK_ENTITY.get()), GravityPlatingBlockEntity::tick);
        }
        return GravityPlatingBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)GravityBlocks.GRAVITY_PLATING_BLOCK_ENTITY.get()), GravityPlatingBlockEntity::tick);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_()) {
            return !GravityPlatingBlock.hasDir(state, context.m_43719_().m_122424_());
        }
        return super.m_6864_(state, context);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61124_((Property)GravityPlatingBlock.directionToProperty(ctx.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)GravityPlatingBlock.directionToProperty(ctx.m_43719_().m_122424_()), (Comparable)Boolean.valueOf(true));
    }

    private boolean canPlaceOn(BlockGetter world, BlockPos pos, Direction side) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60783_(world, pos, side);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        ArrayList<Direction> directions = GravityPlatingBlock.getDirections(state);
        if (directions.size() == 1) {
            return this.canPlaceOn((BlockGetter)world, pos.m_121945_(directions.get(0)), directions.get(0).m_122424_());
        }
        if (directions.size() > 1) {
            for (Direction dir : GravityPlatingBlock.getDirections(world.m_8055_(pos))) {
                directions.remove(dir);
            }
            return this.canPlaceOn((BlockGetter)world, pos.m_121945_(directions.get(0)), directions.get(0).m_122424_());
        }
        return false;
    }

    public static BooleanProperty directionToProperty(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public static boolean hasDir(BlockState blockState, Direction dir) {
        return (Boolean)blockState.m_61143_((Property)GravityPlatingBlock.directionToProperty(dir));
    }

    public static ArrayList<Direction> getDirections(BlockState blockState) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (int directionId = 0; directionId < 6; ++directionId) {
            Direction direction = Direction.m_122376_((int)directionId);
            if (!GravityPlatingBlock.hasDir(blockState, direction)) continue;
            list.add(direction);
        }
        return list;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Direction hitDir = hit.m_82434_();
        Direction plateDir = hitDir.m_122424_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof GravityPlatingBlockEntity)) {
            return InteractionResult.FAIL;
        }
        GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
        return be.interact(level, pos, plateDir, player, hand);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GravityPlatingBlockEntity) {
            GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_()) {
                List<ItemStack> drops = be.getDrops();
                for (ItemStack itemStack : drops) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                    itemEntity.m_32060_();
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof GravityPlatingBlockEntity) {
            GravityPlatingBlockEntity be = (GravityPlatingBlockEntity)blockEntity;
            return be.getDrops();
        }
        return List.of();
    }
}

