/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.network;

import com.min01.gravityapi.capabilities.GravityCapabilities;
import com.min01.gravityapi.util.GCUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateGravityCapabilityPacket {
    private final UUID entityUUID;
    private final boolean noAnimation;
    private final Direction baseGravityDirection;
    private final Direction currentGravityDirection;
    private final double baseGravityStrength;
    private final double currentGravityStrength;

    public UpdateGravityCapabilityPacket(boolean noAnimation, UUID entityUUID, Direction baseGravityDirection, Direction currentGravityDirection, double baseGravityStrength, double currentGravityStrength) {
        this.noAnimation = noAnimation;
        this.entityUUID = entityUUID;
        this.baseGravityDirection = baseGravityDirection;
        this.currentGravityDirection = currentGravityDirection;
        this.baseGravityStrength = baseGravityStrength;
        this.currentGravityStrength = currentGravityStrength;
    }

    public UpdateGravityCapabilityPacket(FriendlyByteBuf buf) {
        this.noAnimation = buf.readBoolean();
        this.entityUUID = buf.m_130259_();
        this.baseGravityDirection = (Direction)buf.m_130066_(Direction.class);
        this.currentGravityDirection = (Direction)buf.m_130066_(Direction.class);
        this.baseGravityStrength = buf.readDouble();
        this.currentGravityStrength = buf.readDouble();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.noAnimation);
        buf.m_130077_(this.entityUUID);
        buf.m_130068_((Enum)this.baseGravityDirection);
        buf.m_130068_((Enum)this.currentGravityDirection);
        buf.writeDouble(this.baseGravityStrength);
        buf.writeDouble(this.currentGravityStrength);
    }

    public static class Handler {
        public static boolean onMessage(UpdateGravityCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    GCUtil.getClientLevel(level -> {
                        Entity entity = GCUtil.getEntityByUUID(level, message.entityUUID);
                        entity.getCapability(GravityCapabilities.GRAVITY).ifPresent(cap -> cap.sync(message.noAnimation, message.baseGravityDirection, message.currentGravityDirection, message.baseGravityStrength, message.currentGravityStrength));
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

