/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin.client;

import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerEntityMixin
extends AbstractClientPlayer {
    public LocalPlayerEntityMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow
    protected abstract boolean m_108746_(BlockPos var1);

    @Redirect(method={"Lnet/minecraft/client/player/LocalPlayer;suffocatesAt(Lnet/minecraft/core/BlockPos;)Z"}, at=@At(value="NEW", target="(DDDDDD)Lnet/minecraft/world/phys/AABB;", ordinal=0))
    private AABB redirect_wouldCollideAt_new_0(double x1, double y1, double z1, double x2, double y2, double z2, BlockPos pos) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return new AABB(x1, y1, z1, x2, y2, z2);
        }
        AABB playerBox = this.m_20191_();
        Vec3 playerMask = RotationUtil.maskPlayerToWorld(0.0, 1.0, 0.0, gravityDirection);
        AABB posBox = new AABB(pos);
        Vec3 posMask = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        return new AABB(playerMask.m_82542_(playerBox.f_82288_, playerBox.f_82289_, playerBox.f_82290_).m_82549_(posMask.m_82542_(posBox.f_82288_, posBox.f_82289_, posBox.f_82290_)), playerMask.m_82542_(playerBox.f_82291_, playerBox.f_82292_, playerBox.f_82293_).m_82549_(posMask.m_82542_(posBox.f_82291_, posBox.f_82292_, posBox.f_82293_)));
    }

    @Inject(method={"Lnet/minecraft/client/player/LocalPlayer;moveTowardsClosestSpace(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushOutOfBlocks(double x, double z, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 pos = RotationUtil.vecPlayerToWorld(x - this.m_20185_(), 0.0, z - this.m_20189_(), gravityDirection).m_82549_(this.m_20182_());
        BlockPos blockPos = BlockPos.m_274446_((Position)pos);
        if (this.m_108746_(blockPos)) {
            Direction[] directions;
            double dx = pos.f_82479_ - (double)blockPos.m_123341_();
            double dy = pos.f_82480_ - (double)blockPos.m_123342_();
            double dz = pos.f_82481_ - (double)blockPos.m_123343_();
            Direction direction = null;
            double minDistToEdge = Double.MAX_VALUE;
            for (Direction playerDirection : directions = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
                double distToEdge;
                Direction worldDirection = RotationUtil.dirPlayerToWorld(playerDirection, gravityDirection);
                double g = worldDirection.m_122434_().m_6150_(dx, dy, dz);
                double d = distToEdge = worldDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - g : g;
                if (!(distToEdge < minDistToEdge) || this.m_108746_(blockPos.m_121945_(worldDirection))) continue;
                minDistToEdge = distToEdge;
                direction = playerDirection;
            }
            if (direction != null) {
                Vec3 velocity = this.m_20184_();
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.m_20334_(0.1 * (double)direction.m_122429_(), velocity.f_82480_, velocity.f_82481_);
                } else if (direction.m_122434_() == Direction.Axis.Z) {
                    this.m_20334_(velocity.f_82479_, velocity.f_82480_, 0.1 * (double)direction.m_122431_());
                }
            }
        }
    }
}

