/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class}, priority=1001)
public abstract class PlayerMixin
extends LivingEntity {
    @Shadow
    @Final
    private Abilities f_36077_;

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    protected abstract boolean m_36343_();

    @Shadow
    protected abstract boolean m_36386_();

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getLookAngle()Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 wrapOperation_travel_getRotationVector_0(Player playerEntity, Operation<Vec3> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)playerEntity);
        if (gravityDirection == Direction.DOWN) {
            return (Vec3)original.call(new Object[]{playerEntity});
        }
        return RotationUtil.vecWorldToPlayer((Vec3)original.call(new Object[]{playerEntity}), gravityDirection);
    }

    @WrapOperation(method={"travel"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;containing(DDD)Lnet/minecraft/core/BlockPos;")})
    private BlockPos modify_move_multiply_0(double x, double y, double z, Operation<BlockPos> original) {
        Vec3 rotate = new Vec3(0.0, 0.9, 0.0);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return (BlockPos)original.call(new Object[]{x - rotate.f_82479_, y - rotate.f_82480_ + 0.9, z - rotate.f_82481_});
    }

    @Redirect(method={"Lnet/minecraft/world/entity/player/Player;drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="NEW", target="(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/item/ItemEntity;", ordinal=0))
    private ItemEntity redirect_dropItem_new_0(Level world, double x, double y, double z, ItemStack stack) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return new ItemEntity(world, x, y, z, stack);
        }
        Vec3 vec3d = this.m_146892_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, 0.3, 0.0, gravityDirection));
        ItemEntity itemEntity = new ItemEntity(world, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, stack);
        return itemEntity;
    }

    @WrapOperation(method={"Lnet/minecraft/world/entity/player/Player;drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/ItemEntity;setDeltaMovement(DDD)V")})
    private void wrapOperation_dropItem_setVelocity(ItemEntity itemEntity, double x, double y, double z, Operation<Void> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            original.call(new Object[]{itemEntity, x, y, z});
            return;
        }
        Vec3 world = RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection);
        GravityChangerAPI.setWorldVelocity((Entity)itemEntity, world);
    }

    @Inject(method={"Lnet/minecraft/world/entity/player/Player;maybeBackOffFromEdge(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/MoverType;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_adjustMovementForSneaking(Vec3 movement, MoverType type, CallbackInfoReturnable<Vec3> cir) {
        Entity this_ = (Entity)this;
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this_);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        if (!this.f_36077_.f_35935_ && (type == MoverType.SELF || type == MoverType.PLAYER) && this.m_36343_() && this.m_36386_()) {
            double d = playerMovement.f_82479_;
            double e = playerMovement.f_82481_;
            double var7 = 0.05;
            while (d != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), 0.0, gravityDirection)))) {
                if (d < 0.05 && d >= -0.05) {
                    d = 0.0;
                    continue;
                }
                if (d > 0.0) {
                    d -= 0.05;
                    continue;
                }
                d += 0.05;
            }
            while (e != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(0.0, (double)(-this.m_274421_()), e, gravityDirection)))) {
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            while (d != 0.0 && e != 0.0 && this_.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82383_(RotationUtil.vecPlayerToWorld(d, (double)(-this.m_274421_()), e, gravityDirection)))) {
                d = d < 0.05 && d >= -0.05 ? 0.0 : (d > 0.0 ? (d -= 0.05) : (d += 0.05));
                if (e < 0.05 && e >= -0.05) {
                    e = 0.0;
                    continue;
                }
                if (e > 0.0) {
                    e -= 0.05;
                    continue;
                }
                e += 0.05;
            }
            cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(d, playerMovement.f_82480_, e, gravityDirection));
        } else {
            cir.setReturnValue((Object)movement);
        }
    }

    @WrapOperation(method={"isAboveGround"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;")})
    private AABB wrapOperation_method_30263_offset_0(AABB box, double x, double y, double z, Operation<AABB> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return (AABB)original.call(new Object[]{box, x, y, z});
        }
        Vec3 world = RotationUtil.vecPlayerToWorld(x, y, z, gravityDirection);
        return (AABB)original.call(new Object[]{box, world.f_82479_, world.f_82480_, world.f_82481_});
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=0)})
    private float wrapOperation_attack_getYaw_0(Player attacker, Operation<Float> original, Entity target) {
        Direction attackerGravityDirection;
        Direction targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker))) {
            return ((Float)original.call(new Object[]{attacker})).floatValue();
        }
        return RotationUtil.rotWorldToPlayer((Vec2)RotationUtil.rotPlayerToWorld((float)((Float)original.call((Object[])new Object[]{attacker})).floatValue(), (float)attacker.m_146909_(), (Direction)attackerGravityDirection), (Direction)targetGravityDirection).f_82470_;
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=1)})
    private float wrapOperation_attack_getYaw_1(Player attacker, Operation<Float> original, Entity target) {
        Direction attackerGravityDirection;
        Direction targetGravityDirection = GravityChangerAPI.getGravityDirection(target);
        if (targetGravityDirection == (attackerGravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker))) {
            return ((Float)original.call(new Object[]{attacker})).floatValue();
        }
        return RotationUtil.rotWorldToPlayer((Vec2)RotationUtil.rotPlayerToWorld((float)((Float)original.call((Object[])new Object[]{attacker})).floatValue(), (float)attacker.m_146909_(), (Direction)attackerGravityDirection), (Direction)targetGravityDirection).f_82470_;
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=2)})
    private float wrapOperation_attack_getYaw_2(Player attacker, Operation<Float> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker);
        if (gravityDirection == Direction.DOWN) {
            return ((Float)original.call(new Object[]{attacker})).floatValue();
        }
        return RotationUtil.rotPlayerToWorld((float)((Float)original.call((Object[])new Object[]{attacker})).floatValue(), (float)attacker.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getYRot()F", ordinal=3)})
    private float wrapOperation_attack_getYaw_3(Player attacker, Operation<Float> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)attacker);
        if (gravityDirection == Direction.DOWN) {
            return ((Float)original.call(new Object[]{attacker})).floatValue();
        }
        return RotationUtil.rotPlayerToWorld((float)((Float)original.call((Object[])new Object[]{attacker})).floatValue(), (float)attacker.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @WrapOperation(method={"addParticlesAroundSelf"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void modify_addDeathParticless_addParticle_0(Level instance, ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz, Operation<Void> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            original.call(new Object[]{instance, particle, x, y, z, dx, dy, dz});
        } else {
            Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(x, y, z), gravityDirection));
            original.call(new Object[]{instance, particle, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, dx, dy, dz});
        }
    }

    @WrapOperation(method={"aiStep"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;")})
    private AABB modify_tickMovement_expand_0(AABB instance, double x, double y, double z, Operation<AABB> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return (AABB)original.call(new Object[]{instance, x, y, z});
        }
        Vec3 vec3d = RotationUtil.maskPlayerToWorld(x, y, z, gravityDirection);
        return (AABB)original.call(new Object[]{instance, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_});
    }
}

