/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.util.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract float m_5675_(float var1);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=0))
    private double redirect_travel_getY_0(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20186_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)livingEntity.m_20182_(), (Direction)gravityDirection).f_82480_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=1))
    private double redirect_travel_getY_1(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20186_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)livingEntity.m_20182_(), (Direction)gravityDirection).f_82480_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=2))
    private double redirect_travel_getY_2(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20186_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)livingEntity.m_20182_(), (Direction)gravityDirection).f_82480_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getY()D", ordinal=3))
    private double redirect_travel_getY_3(LivingEntity livingEntity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return livingEntity.m_20186_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)livingEntity.m_20182_(), (Direction)gravityDirection).f_82480_;
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;getLookAngle()Lnet/minecraft/world/phys/Vec3;", ordinal=0), ordinal=2)
    private Vec3 modify_travel_Vec3d_2(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyArg(method={"playBlockFallSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"), index=0)
    private BlockPos modify_playBlockFallSound_getBlockState_0(BlockPos blockPos) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return blockPos;
        }
        return BlockPos.m_274446_((Position)this.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection)));
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="NEW", target="(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 redirect_canSee_new_0(double x, double y, double z) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return new Vec3(x, y, z);
        }
        return this.m_146892_();
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hasLineOfSight(Lnet/minecraft/world/entity/Entity;)Z"}, at=@At(value="NEW", target="(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=1))
    private Vec3 redirect_canSee_new_1(double x, double y, double z, Entity entity) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return new Vec3(x, y, z);
        }
        return entity.m_146892_();
    }

    @Inject(method={"Lnet/minecraft/world/entity/LivingEntity;getLocalBoundsForPose(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getBoundingBox(Pose pose, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB box = (AABB)cir.getReturnValue();
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection));
    }

    @Inject(method={"calculateEntityAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_updateLimbs(boolean flutter, CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 playerPosDelta = RotationUtil.vecWorldToPlayer(entity.m_20185_() - entity.f_19854_, entity.m_20186_() - entity.f_19855_, entity.m_20189_() - entity.f_19856_, gravityDirection);
        double d = playerPosDelta.f_82479_;
        double e = flutter ? playerPosDelta.f_82480_ : 0.0;
        double f = playerPosDelta.f_82481_;
        float g = (float)Math.sqrt(d * d + e * e + f * f) * 4.0f;
        if (g > 1.0f) {
            g = 1.0f;
        }
        entity.f_267362_.m_267566_(g, 0.4f);
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0)})
    private double wrapOperation_tick_getX_0(LivingEntity livingEntity, Operation<Double> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return (Double)original.call(new Object[]{livingEntity});
        }
        return RotationUtil.vecWorldToPlayer((double)(((Double)original.call((Object[])new Object[]{livingEntity})).doubleValue() - livingEntity.f_19854_), (double)(livingEntity.m_20186_() - livingEntity.f_19855_), (double)(livingEntity.m_20189_() - livingEntity.f_19856_), (Direction)gravityDirection).f_82479_ + livingEntity.f_19854_;
    }

    @WrapOperation(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0)})
    private double wrapOperation_tick_getZ_0(LivingEntity livingEntity, Operation<Double> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)livingEntity);
        if (gravityDirection == Direction.DOWN) {
            return (Double)original.call(new Object[]{livingEntity});
        }
        return RotationUtil.vecWorldToPlayer((double)(livingEntity.m_20185_() - livingEntity.f_19854_), (double)(livingEntity.m_20186_() - livingEntity.f_19855_), (double)(((Double)original.call((Object[])new Object[]{livingEntity})).doubleValue() - livingEntity.f_19856_), (Direction)gravityDirection).f_82481_ + livingEntity.f_19856_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D", ordinal=0))
    private double redirect_damage_getX_0(Entity attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D", ordinal=0))
    private double redirect_damage_getZ_0(Entity attacker) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection(attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0))
    private double redirect_damage_getX_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_damage_getZ_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=0))
    private double redirect_knockback_getX_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20185_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=0))
    private double redirect_knockback_getZ_0(LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            return target.m_20189_();
        }
        return RotationUtil.vecWorldToPlayer((Vec3)target.m_20182_(), (Direction)gravityDirection).f_82481_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getX()D", ordinal=1))
    private double redirect_knockback_getX_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20185_();
            }
            return attacker.m_146892_().f_82479_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82479_;
    }

    @Redirect(method={"Lnet/minecraft/world/entity/LivingEntity;blockedByShield(Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getZ()D", ordinal=1))
    private double redirect_knockback_getZ_1(LivingEntity attacker, LivingEntity target) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)target);
        if (gravityDirection == Direction.DOWN) {
            if (GravityChangerAPI.getGravityDirection((Entity)attacker) == Direction.DOWN) {
                return attacker.m_20189_();
            }
            return attacker.m_146892_().f_82481_;
        }
        return RotationUtil.vecWorldToPlayer((Vec3)attacker.m_146892_(), (Direction)gravityDirection).f_82481_;
    }

    @WrapOperation(method={"spawnItemParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;add(DDD)Lnet/minecraft/world/phys/Vec3;", ordinal=0)})
    private Vec3 wrapOperation_spawnItemParticles_add_0(Vec3 vec3d, double x, double y, double z, Operation<Vec3> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return (Vec3)original.call(new Object[]{vec3d, x, y, z});
        }
        Vec3 rotated = RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
        return (Vec3)original.call(new Object[]{this.m_146892_(), rotated.f_82479_, rotated.f_82480_, rotated.f_82481_});
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/LivingEntity;spawnItemParticles(Lnet/minecraft/world/item/ItemStack;I)V"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/phys/Vec3;yRot(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0), ordinal=0)
    private Vec3 modify_spawnItemParticles_Vec3d_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @WrapOperation(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void modify_tickStatusEffects_addParticle_0(Level instance, ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz, Operation<Void> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            original.call(new Object[]{instance, particle, x, y, z, dx, dy, dz});
        } else {
            Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(x, y, z), gravityDirection));
            original.call(new Object[]{instance, particle, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, dx, dy, dz});
        }
    }

    @WrapOperation(method={"makePoofParticles"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0)})
    private void modify_addDeathParticless_addParticle_0(Level instance, ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz, Operation<Void> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            original.call(new Object[]{instance, particle, x, y, z, dx, dy, dz});
        } else {
            Vec3 vec3d = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(this.m_20182_().m_82492_(x, y, z), gravityDirection));
            original.call(new Object[]{instance, particle, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, dx, dy, dz});
        }
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/LivingEntity;isDamageSourceBlocked(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/LivingEntity;getViewVector(F)Lnet/minecraft/world/phys/Vec3;", ordinal=0), ordinal=1)
    private Vec3 modify_blockedByShield_Vec3d_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyConstant(method={"Lnet/minecraft/world/entity/LivingEntity;travel(Lnet/minecraft/world/phys/Vec3;)V"}, constant={@Constant(doubleValue=0.08)})
    private double multiplyGravity(double constant) {
        return constant * GravityChangerAPI.getGravityStrength(this);
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/LivingEntity;calculateFallDamage(FF)I"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float diminishFallDamage(float value) {
        return value * (float)Math.sqrt(GravityChangerAPI.getGravityStrength(this));
    }
}

