/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.capabilities.GravityCapabilities;
import com.min01.gravityapi.capabilities.IGravityCapability;
import com.min01.gravityapi.config.GravityConfig;
import com.min01.gravityapi.util.RotationUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private Vec3 f_19825_;
    @Shadow
    private EntityDimensions f_19815_;
    @Shadow
    private float f_19816_;
    @Shadow
    public double f_19854_;
    @Shadow
    public double f_19855_;
    @Shadow
    public double f_19856_;
    @Shadow
    public Level f_19853_;
    @Shadow
    public boolean f_19794_;
    @Shadow
    @Final
    protected RandomSource f_19796_;
    @Shadow
    public float f_19789_;

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract Vec3 m_146892_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract int m_146903_();

    @Shadow
    public abstract int m_146907_();

    @Shadow
    public abstract Vec3 m_20184_();

    @Shadow
    public abstract boolean m_20160_();

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public static Vec3 m_198900_(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions) {
        return null;
    }

    @Shadow
    public abstract Vec3 m_20182_();

    @Shadow
    public abstract boolean m_20365_(Entity var1);

    @Shadow
    public abstract void m_5997_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_6088_();

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract float m_5675_(float var1);

    @Shadow
    public abstract float m_146908_();

    @Shadow
    public abstract float m_146909_();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        Entity entity = (Entity)Entity.class.cast(this);
        entity.getCapability(GravityCapabilities.GRAVITY).ifPresent(IGravityCapability::tick);
    }

    @WrapOperation(method={"Lnet/minecraft/world/entity/Entity;makeBoundingBox()Lnet/minecraft/world/phys/AABB;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityDimensions;makeBoundingBox(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/AABB;")})
    private AABB wrapOperation_canChangeIntoPose_getBoundingBox(EntityDimensions dimensions, Vec3 pos, Operation<AABB> original) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return (AABB)original.call(new Object[]{dimensions, pos});
        }
        AABB box = dimensions.m_20384_(0.0, 0.0, 0.0);
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            box = box.m_82386_(0.0, -1.0E-6, 0.0);
        }
        return RotationUtil.boxPlayerToWorld(box, gravityDirection).m_82383_(pos);
    }

    @Inject(method={"getBoundingBoxForPose"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBoundingBoxForPose(Pose pose, CallbackInfoReturnable<AABB> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB aabb = (AABB)cir.getReturnValue();
        if (gravityDirection.m_122421_() == Direction.AxisDirection.POSITIVE) {
            aabb = aabb.m_82386_(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(aabb, gravityDirection));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getRotationVector(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getBlockPosBelowThatAffectsMyMovement()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getVelocityAffectingPos(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)BlockPos.m_274446_((Position)this.f_19825_.m_82549_(Vec3.m_82528_((Vec3i)gravityDirection.m_122436_()).m_82490_(0.5000001))));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePos(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(0.0, (double)this.f_19816_, 0.0, gravityDirection).m_82549_(this.f_19825_));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getCameraPosVec(float tickDelta, CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        Vec3 vec3d = RotationUtil.vecPlayerToWorld(0.0, (double)this.f_19816_, 0.0, gravityDirection);
        double d = Mth.m_14139_((double)tickDelta, (double)this.f_19854_, (double)this.m_20185_()) + vec3d.f_82479_;
        double e = Mth.m_14139_((double)tickDelta, (double)this.f_19855_, (double)this.m_20186_()) + vec3d.f_82480_;
        double f = Mth.m_14139_((double)tickDelta, (double)this.f_19856_, (double)this.m_20189_()) + vec3d.f_82481_;
        cir.setReturnValue((Object)new Vec3(d, e, f));
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getLightLevelDependentMagicValue()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getBrightnessAtFEyes(CallbackInfoReturnable<Float> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(this.f_19853_.m_151577_(this.m_146903_(), this.m_146907_()) ? this.f_19853_.m_220417_(BlockPos.m_274446_((Position)this.m_146892_())) : 0.0f));
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        if (!((Entity)this instanceof Player)) {
            return RotationUtil.vecEntityToWorld(vec3d, gravityDirection);
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=0, argsOnly=true)
    private Vec3 modify_move_Vec3d_0_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=1)
    private Vec3 modify_move_Vec3d_1(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;getOnPosLegacy()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getLandingPos(CallbackInfoReturnable<BlockPos> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection).m_82549_(this.f_19825_));
        cir.setReturnValue((Object)blockPos);
    }

    @ModifyVariable(method={"collide"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/Level;getEntityCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;", ordinal=0), ordinal=0)
    private Vec3 modify_adjustMovementForCollisions_Vec3d_0(Vec3 vec3d) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_adjustMovementForCollisions(CallbackInfoReturnable<Vec3> cir) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @WrapOperation(method={"collide"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;expandTowards(DDD)Lnet/minecraft/world/phys/AABB;")})
    private AABB redirect_adjustMovementForCollisions_stretch_1(AABB instance, double x, double y, double z, Operation<AABB> original) {
        Vec3 rotate = new Vec3(x, y, z);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return (AABB)original.call(new Object[]{instance, rotate.f_82479_, rotate.f_82480_, rotate.f_82481_});
    }

    @ModifyArg(method={"collide"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/AABB;"))
    private Vec3 redirect_adjustMovementForCollisions_offset_0(Vec3 rotate) {
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return rotate;
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private static Vec3 modify_adjustMovementForCollisions_Vec3d_0(Vec3 vec3d, Entity entity) {
        if (entity == null) {
            return vec3d;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void inject_adjustMovementForCollisions(Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> collisions, CallbackInfoReturnable<Vec3> cir) {
        if (entity == null) {
            return;
        }
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecWorldToPlayer((Vec3)cir.getReturnValue(), gravityDirection));
    }

    @Redirect(method={"Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collideWithShapes(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private static Vec3 redirect_adjustMovementForCollisions_adjustMovementForCollisions_0(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> collisions, Entity entity) {
        boolean isZLargerThanX;
        Direction gravityDirection;
        if (entity == null || (gravityDirection = GravityChangerAPI.getGravityDirection(entity)) == Direction.DOWN) {
            return EntityMixin.m_198900_(movement, entityBoundingBox, collisions);
        }
        Vec3 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        double playerMovementX = playerMovement.f_82479_;
        double playerMovementY = playerMovement.f_82480_;
        double playerMovementZ = playerMovement.f_82481_;
        Direction directionX = RotationUtil.dirPlayerToWorld(Direction.EAST, gravityDirection);
        Direction directionY = RotationUtil.dirPlayerToWorld(Direction.UP, gravityDirection);
        Direction directionZ = RotationUtil.dirPlayerToWorld(Direction.SOUTH, gravityDirection);
        if (playerMovementY != 0.0 && (playerMovementY = Shapes.m_193135_((Direction.Axis)directionY.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementY * (double)directionY.m_122421_().m_122540_())) * (double)directionY.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, playerMovementY, 0.0, gravityDirection));
        }
        boolean bl = isZLargerThanX = Math.abs(playerMovementX) < Math.abs(playerMovementZ);
        if (isZLargerThanX && playerMovementZ != 0.0 && (playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_()) != 0.0) {
            entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(0.0, 0.0, playerMovementZ, gravityDirection));
        }
        if (playerMovementX != 0.0) {
            playerMovementX = Shapes.m_193135_((Direction.Axis)directionX.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementX * (double)directionX.m_122421_().m_122540_())) * (double)directionX.m_122421_().m_122540_();
            if (!isZLargerThanX && playerMovementX != 0.0) {
                entityBoundingBox = entityBoundingBox.m_82383_(RotationUtil.vecPlayerToWorld(playerMovementX, 0.0, 0.0, gravityDirection));
            }
        }
        if (!isZLargerThanX && playerMovementZ != 0.0) {
            playerMovementZ = Shapes.m_193135_((Direction.Axis)directionZ.m_122434_(), (AABB)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.m_122421_().m_122540_())) * (double)directionZ.m_122421_().m_122540_();
        }
        return RotationUtil.vecPlayerToWorld(playerMovementX, playerMovementY, playerMovementZ, gravityDirection);
    }

    @WrapOperation(method={"isInWall"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;ofSize(Lnet/minecraft/world/phys/Vec3;DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0)})
    private AABB modify_isInsideWall_of_0(Vec3 vec3, double x, double y, double z, Operation<AABB> original) {
        Vec3 rotate = new Vec3(x, y, z);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return (AABB)original.call(new Object[]{vec3, rotate.f_82479_, rotate.f_82480_, rotate.f_82481_});
    }

    @ModifyArg(method={"getDirection"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction;fromYRot(D)Lnet/minecraft/core/Direction;"))
    private double redirect_getHorizontalFacing_getYaw_0(double rotation) {
        Entity this_ = (Entity)this;
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this_);
        if (gravityDirection == Direction.DOWN) {
            return rotation;
        }
        return RotationUtil.rotPlayerToWorld((float)((float)rotation), (float)this.m_146909_(), (Direction)gravityDirection).f_82470_;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;spawnSprintParticle()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_spawnSprintingParticles(CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 floorPos = this.m_20182_().m_82546_(RotationUtil.vecPlayerToWorld(0.0, (double)0.2f, 0.0, gravityDirection));
        BlockPos blockPos = BlockPos.m_274446_((Position)floorPos);
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = this.m_20182_().m_82549_(RotationUtil.vecPlayerToWorld((this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, 0.1, (this.f_19796_.m_188500_() - 0.5) * (double)this.f_19815_.f_20377_, gravityDirection));
            Vec3 playerVelocity = this.m_20184_();
            Vec3 particleVelocity = RotationUtil.vecPlayerToWorld(playerVelocity.f_82479_ * -4.0, 1.5, playerVelocity.f_82481_ * -4.0, gravityDirection);
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushAwayFrom(Entity entity, CallbackInfo ci) {
        Direction gravityDirection = GravityChangerAPI.getGravityDirection((Entity)this);
        Direction otherGravityDirection = GravityChangerAPI.getGravityDirection(entity);
        if (gravityDirection == Direction.DOWN && otherGravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (!(this.m_20365_(entity) || entity.f_19794_ || this.f_19794_)) {
            double g;
            Vec3 entityOffset = entity.m_20191_().m_82399_().m_82546_(this.m_20191_().m_82399_());
            Vec3 playerEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, gravityDirection);
            double dx = playerEntityOffset.f_82479_;
            double dz = playerEntityOffset.f_82481_;
            double f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!this.m_20160_()) {
                    this.m_5997_(-dx, 0.0, -dz);
                }
            }
            Vec3 entityEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, otherGravityDirection);
            dx = entityEntityOffset.f_82479_;
            dz = entityEntityOffset.f_82481_;
            f = Mth.m_14005_((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.m_20160_()) {
                    entity.m_5997_(dx, 0.0, dz);
                }
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;checkBelowWorld()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_attemptTickInVoid(CallbackInfo ci) {
        Entity this_ = (Entity)this;
        Direction gravityDirection = GravityChangerAPI.getGravityDirection(this_);
        if (((Boolean)GravityConfig.voidDamageAboveWorld.get()).booleanValue() && this.m_20186_() > (double)(this.f_19853_.m_151558_() + 256) && gravityDirection == Direction.UP) {
            this.m_6088_();
            ci.cancel();
            return;
        }
        if (((Boolean)GravityConfig.voidDamageOnHorizontalFallTooFar.get()).booleanValue() && gravityDirection.m_122434_() != Direction.Axis.Y && this.f_19789_ > 1024.0f) {
            this.m_6088_();
            ci.cancel();
            return;
        }
    }

    @WrapOperation(method={"isFree(DDD)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;move(DDD)Lnet/minecraft/world/phys/AABB;", ordinal=0)})
    private AABB redirect_doesNotCollide_offset_0(AABB instance, double x, double y, double z, Operation<AABB> original) {
        Vec3 rotate = new Vec3(x, y, z);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityChangerAPI.getGravityDirection((Entity)this));
        return (AABB)original.call(new Object[]{instance, rotate.f_82479_, rotate.f_82480_, rotate.f_82481_});
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private double submergedInWaterEyeFix(double d) {
        d = this.m_146892_().m_7098_();
        return d;
    }

    @ModifyVariable(method={"Lnet/minecraft/world/entity/Entity;updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private BlockPos submergedInWaterPosFix(BlockPos blockpos) {
        blockpos = BlockPos.m_274446_((Position)this.m_146892_());
        return blockpos;
    }
}

