/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class GravityConfig {
    public static final GravityConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static ForgeConfigSpec.ConfigValue<Integer> rotationTime;
    public static ForgeConfigSpec.BooleanValue worldVelocity;
    public static ForgeConfigSpec.DoubleValue gravityStrengthMultiplier;
    public static ForgeConfigSpec.BooleanValue resetGravityOnRespawn;
    public static ForgeConfigSpec.BooleanValue voidDamageAboveWorld;
    public static ForgeConfigSpec.BooleanValue voidDamageOnHorizontalFallTooFar;
    public static ForgeConfigSpec.BooleanValue autoJumpOnGravityPlateInnerCorner;
    public static ForgeConfigSpec.BooleanValue adjustPositionAfterChangingGravity;

    public GravityConfig(ForgeConfigSpec.Builder config) {
        config.push("Gravity Settings");
        rotationTime = config.comment("animation rotation time").defineInRange("rotationTime", 500, 0, Integer.MAX_VALUE);
        gravityStrengthMultiplier = config.comment("gravity strength multiplier").defineInRange("gravityStrengthMultiplier", 1.0, 0.0, 3.4028234663852886E38);
        worldVelocity = config.comment("world velocity").define("worldVelocity", false);
        resetGravityOnRespawn = config.comment("reset gravity on respawn").define("resetGravityOnRespawn", true);
        voidDamageAboveWorld = config.comment("void damage when above world").define("voidDamageAboveWorld", true);
        voidDamageOnHorizontalFallTooFar = config.comment("void damage when horizontally fall too far").define("voidDamageOnHorizontalFallTooFar", true);
        autoJumpOnGravityPlateInnerCorner = config.comment("auto jump on gravity plate inner corner").define("autoJumpOnGravityPlateInnerCorner", true);
        adjustPositionAfterChangingGravity = config.comment("adjust position after gravity change").define("adjustPositionAfterChangingGravity", true);
        config.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(GravityConfig::new);
        CONFIG = (GravityConfig)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

