/*
 * Decompiled with CFR 0.152.
 */
package com.min01.gravityapi.command;

import com.min01.gravityapi.api.GravityChangerAPI;
import com.min01.gravityapi.capabilities.GravityCapabilityImpl;
import com.min01.gravityapi.command.DirectionArgumentType;
import com.min01.gravityapi.command.LocalDirection;
import com.min01.gravityapi.command.LocalDirectionArgumentType;
import com.min01.gravityapi.util.GCUtil;
import com.min01.gravityapi.util.RotationUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.Validate;

public class GravityCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"gravity").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"set_base_direction").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"direction", (ArgumentType)new DirectionArgumentType()).executes(context -> {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            Direction direction = DirectionArgumentType.getDirection(context, "direction");
            GravityChangerAPI.setBaseGravityDirection(entity, direction);
            return 1;
        })).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
            Direction direction = DirectionArgumentType.getDirection(context, "direction");
            for (Entity entity : entities) {
                GravityChangerAPI.setBaseGravityDirection(entity, direction);
            }
            return entities.size();
        }))));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(context -> {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            GravityChangerAPI.resetGravity(entity);
            return 1;
        })).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
            for (Entity entity : entities) {
                GravityChangerAPI.resetGravity(entity);
            }
            return entities.size();
        })));
        builder.then(Commands.m_82127_((String)"set_base_strength").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"strength", (ArgumentType)DoubleArgumentType.doubleArg((double)-20.0, (double)20.0)).executes(context -> {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            double strength = DoubleArgumentType.getDouble((CommandContext)context, (String)"strength");
            return GravityCommand.executeSetBaseStrength(List.of(entity), strength);
        })).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
            double strength = DoubleArgumentType.getDouble((CommandContext)context, (String)"strength");
            return GravityCommand.executeSetBaseStrength(entities, strength);
        }))));
        builder.then(Commands.m_82127_((String)"view").executes(context -> {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            GravityCapabilityImpl component = GravityChangerAPI.getGravityComponent(entity);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"gravity_changer.command.inform", (Object[])new Object[]{component.getBaseGravityDirection().m_122433_(), component.getBaseGravityStrength()}), false);
            return 0;
        }));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"randomize_base_direction").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Entity entity = source.m_81373_();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            return GravityCommand.executeRandomizeBaseDirection(source, List.of(entity));
        })).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
            return GravityCommand.executeRandomizeBaseDirection(source, entities);
        })));
        builder.then(Commands.m_82127_((String)"set_relative_base_direction").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"relativeDirection", (ArgumentType)new LocalDirectionArgumentType()).executes(context -> {
            LocalDirection relativeDirection = LocalDirectionArgumentType.getDirection(context, "relativeDirection");
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            Validate.isTrue((entity != null ? 1 : 0) != 0);
            return GravityCommand.executeSetRelativeBaseDir((CommandSourceStack)context.getSource(), relativeDirection, List.of(entity));
        })).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            LocalDirection relativeDirection = LocalDirectionArgumentType.getDirection(context, "relativeDirection");
            Collection entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
            return GravityCommand.executeSetRelativeBaseDir((CommandSourceStack)context.getSource(), relativeDirection, entities);
        }))));
        dispatcher.register(builder);
    }

    private static int executeSetBaseStrength(Collection<? extends Entity> entities, double strength) {
        for (Entity entity : entities) {
            GravityChangerAPI.setBaseGravityStrength(entity, strength);
        }
        return entities.size();
    }

    private static int executeRandomizeBaseDirection(CommandSourceStack source, Collection<? extends Entity> entities) {
        RandomSource random = source.m_81372_().f_46441_;
        for (Entity entity : entities) {
            Direction gravityDirection = Direction.m_235672_((RandomSource)random);
            GravityChangerAPI.setBaseGravityDirection(entity, gravityDirection);
        }
        return entities.size();
    }

    private static void getSendFeedback(CommandSourceStack source, Entity entity, Direction gravityDirection) {
        MutableComponent text = GCUtil.getDirectionText(gravityDirection);
        if (source.m_81373_() != null && source.m_81373_() == entity) {
            source.m_288197_(() -> GravityCommand.lambda$getSendFeedback$13((Component)text), true);
        } else {
            source.m_288197_(() -> GravityCommand.lambda$getSendFeedback$14(entity, (Component)text), true);
        }
    }

    private static int executeSetRelativeBaseDir(CommandSourceStack source, LocalDirection relativeDirection, Collection<? extends Entity> entities) {
        int i = 0;
        for (Entity entity : entities) {
            Direction gravityDirection = GravityChangerAPI.getGravityDirection(entity);
            Direction combinedRelativeDirection = switch (relativeDirection) {
                default -> throw new IncompatibleClassChangeError();
                case LocalDirection.DOWN -> Direction.DOWN;
                case LocalDirection.UP -> Direction.UP;
                case LocalDirection.FORWARD, LocalDirection.BACKWARD, LocalDirection.LEFT, LocalDirection.RIGHT -> Direction.m_122407_((int)(relativeDirection.getHorizontalOffset() + Direction.m_122364_((double)entity.m_146908_()).m_122416_()));
            };
            Direction newGravityDirection = RotationUtil.dirPlayerToWorld(combinedRelativeDirection, gravityDirection);
            GravityChangerAPI.setBaseGravityDirection(entity, newGravityDirection);
            GravityCommand.getSendFeedback(source, entity, newGravityDirection);
            ++i;
        }
        return i;
    }

    private static /* synthetic */ Component lambda$getSendFeedback$14(Entity entity, Component text) {
        return Component.m_237110_((String)"commands.gravity.get.other", (Object[])new Object[]{entity.m_5446_(), text});
    }

    private static /* synthetic */ Component lambda$getSendFeedback$13(Component text) {
        return Component.m_237110_((String)"commands.gravity.get.self", (Object[])new Object[]{text});
    }
}

