/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.network;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.common.network.PacketBase;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.modintegration.curios.Curios_Base;

public class PacketOpenBag
extends PacketBase {
    private final String location;
    private final IOpenable.Type itype;

    public PacketOpenBag(String location, IOpenable.Type itype) {
        this.location = location;
        this.itype = itype;
    }

    public static void writeData(PacketOpenBag packet, FriendlyByteBuf buffer) {
        PacketOpenBag.writeString((FriendlyByteBuf)buffer, (String)packet.location);
        buffer.writeByte((int)((byte)packet.itype.ordinal()));
    }

    public static PacketOpenBag readData(FriendlyByteBuf buffer) {
        return new PacketOpenBag(PacketOpenBag.readString((FriendlyByteBuf)buffer), IOpenable.Type.values()[buffer.readByte()]);
    }

    public void handleClientSide(Player player) {
    }

    public void handleServerSide(Player player) {
        if (this.location.startsWith("curio|")) {
            ItemStack stack;
            Pair<String, ItemStack> curioData = Curios_Base.CURIO_SCANNER.apply((LivingEntity)player, this.itype);
            if (curioData != null && ((String)curioData.getFirst()).equals(this.location) && !(stack = (ItemStack)curioData.getSecond()).m_41619_() && stack.m_41720_() instanceof IOpenable && this.itype.test(stack)) {
                ((IOpenable)stack.m_41720_()).openInventory(stack, player);
            }
            return;
        }
        if (this.location.startsWith("inventory|")) {
            ItemStack stack;
            int index = Integer.parseInt(this.location.substring(10));
            NonNullList items = player.m_150109_().f_35974_;
            if (index >= 0 && index < items.size() && !(stack = (ItemStack)items.get(index)).m_41619_() && stack.m_41720_() instanceof IOpenable && this.itype.test(stack)) {
                ((IOpenable)stack.m_41720_()).openInventory(stack, player);
            }
        }
    }
}

