/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.modintegration.curios.Curios_Base;

public class ItemEnderPouch
extends Item
implements IOpenable {
    private static final Component VANILLA_ENDER_CHEST_NAME = Component.m_237115_((String)"container.enderchest");

    public ItemEnderPouch(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)this, (Object)"open", (stack, world, entity, number) -> IOpenable.isOpen(stack) ? 1.0f : 0.0f)));
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        IOpenable.setOpenState(stack, false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return this.openInventory(player.m_21120_(hand), world, player);
    }

    @Override
    public InteractionResultHolder<ItemStack> openInventory(ItemStack stack, Level world, Player player) {
        if (((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            IOpenable.setOpenState(stack, true);
            player.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            if (!world.m_5776_()) {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((id, invPlayer, entity) -> ChestMenu.m_39237_((int)id, (Inventory)invPlayer, (Container)invPlayer.f_35978_.m_36327_()), VANILLA_ENDER_CHEST_NAME));
                player.m_36220_(Stats.f_12963_);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        this.iOpenableInventoryTick(stack, entity);
    }

    @Override
    public boolean isContainerOpen(Player player) {
        return player != null && player.f_36096_ instanceof ChestMenu;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowEnderPouch.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237113_((String)"\u00a7o").m_7220_((Component)Component.m_237115_((String)"info.enderchests.craftingmaterial")));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return stack.m_41619_() ? null : new CapabilityProvider(stack);
    }

    private record CapabilityProvider(ItemStack stack) implements ICapabilityProvider
    {
        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            LazyOptional<T> curio = Curios_Base.INSTANCE.getCapability(this.stack, capability, "ender_pouch");
            if (curio.isPresent()) {
                return curio;
            }
            return LazyOptional.empty();
        }
    }
}

