/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import com.mojang.logging.LogUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.misc.EventHandlerClient;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.EventHandler;
import shetiphian.enderchests.modintegration.ModIntegration;
import shetiphian.enderchests.network.NetworkHandler;

@Mod(value="enderchests")
public class EnderChests {
    public static final String MOD_ID = "enderchests";
    public static EnderChests INSTANCE;
    public static Logger LOGGER;

    public EnderChests() {
        INSTANCE = this;
        LOGGER = LogUtils.getLogger();
        IEventBus MOD_EVENT_BUS = FMLJavaModLoadingContext.get().getModEventBus();
        Roster.setup(MOD_EVENT_BUS);
        MOD_EVENT_BUS.register((Object)this);
        MOD_EVENT_BUS.addListener(this::commonSetup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MOD_EVENT_BUS.addListener(this::clientSetup);
            MOD_EVENT_BUS.addListener(EventHandlerClient::registerBindings);
        });
        MOD_EVENT_BUS.addListener(this::init);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configuration.SPEC_CLIENT, "enderchests-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.SPEC_COMMON, "enderchests.toml");
        MOD_EVENT_BUS.register(Configuration.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Roster.process();
        Values.minecraftDir = FMLPaths.GAMEDIR.get().toAbsolutePath().toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSetup(FMLClientSetupEvent event) {
        RenderRegistry.setupNow();
        event.enqueueWork(RenderRegistry::setupLater);
        event.enqueueWork(Roster::registerScreenFactories);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    private void init(InterModEnqueueEvent event) {
        NetworkHandler.initialise(MOD_ID);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        ModIntegration.INSTANCE.init();
    }

    private void serverStarted(ServerStartedEvent event) {
        ChestHelper.INSTANCE.loadChestData();
    }

    private void serverStopped(ServerStoppedEvent event) {
        ChestHelper.INSTANCE.unloadChestData();
        Configuration.CAN_PROCESS_TAGS = false;
    }
}

