/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaCollector;

public abstract class GeneratingFlowerBlockEntity
extends BindableSpecialFlowerBlockEntity<ManaCollector> {
    private static final ResourceLocation SPREADER_ID = new ResourceLocation("botania", "mana_spreader");
    public static final int LINK_RANGE = 6;
    private static final String TAG_MANA = "mana";
    private int mana;

    public GeneratingFlowerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, ManaCollector.class);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            double particleChance = 1.0 - (double)this.getMana() / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                Vec3 offset = this.m_58904_().m_8055_(this.m_58899_()).m_60824_((BlockGetter)this.m_58904_(), this.m_58899_());
                double x = (double)this.m_58899_().m_123341_() + offset.f_82479_;
                double y = (double)this.m_58899_().m_123342_() + offset.f_82480_;
                double z = (double)this.m_58899_().m_123343_() + offset.f_82481_;
                BotaniaAPI.instance().sparkleFX(this.m_58904_(), x + 0.3 + Math.random() * 0.5, y + 0.5 + Math.random() * 0.5, z + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
        this.emptyManaIntoCollector();
    }

    @Override
    public int getBindingRadius() {
        return 6;
    }

    @Override
    @Nullable
    public BlockPos findClosestTarget() {
        ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        ManaCollector closestCollector = network.getClosestCollector(this.m_58899_(), this.m_58904_(), this.getBindingRadius());
        return closestCollector == null ? null : closestCollector.getManaReceiverPos();
    }

    public void emptyManaIntoCollector() {
        ManaCollector collector = (ManaCollector)this.findBoundTile();
        if (collector != null && !collector.isFull() && this.getMana() > 0) {
            int manaval = Math.min(this.getMana(), collector.getMaxMana() - collector.getCurrentMana());
            this.addMana(-manaval);
            collector.receiveMana(manaval);
            this.sync();
        }
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public void addMana(int mana) {
        this.mana = Math.min(this.getMaxMana(), this.getMana() + mana);
        this.m_6596_();
    }

    @Override
    public ItemStack getDefaultHudIcon() {
        return BuiltInRegistries.f_257033_.m_6612_(SPREADER_ID).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.m_128451_(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_MANA, this.getMana());
    }
}

