/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import uppers.Uppers;
import uppers.blocks.UpperBlock;
import uppers.tiles.IUpper;
import uppers.tiles.InventoryCodeHooksTweaked;
import uppers.tiles.UpperItemHandler;

public class UpperBlockEntity
extends RandomizableContainerBlockEntity
implements IUpper {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int cooldownTime = -1;
    private long tickedGameTime;

    public UpperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Uppers.UPPER_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compound)) {
            ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        }
        this.cooldownTime = compound.m_128451_("TransferCooldown");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.items);
        }
        compound.m_128405_("TransferCooldown", this.cooldownTime);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public ItemStack m_7407_(int index, int count) {
        this.m_59640_(null);
        return ContainerHelper.m_18969_(this.m_7086_(), (int)index, (int)count);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_59640_(null);
        this.m_7086_().set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    protected Component m_6820_() {
        return Component.m_237110_((String)"container.upper", (Object[])new Object[0]);
    }

    public static void pushItemsTick(Level level, BlockPos pos, BlockState state, UpperBlockEntity blockEntity) {
        --blockEntity.cooldownTime;
        blockEntity.tickedGameTime = level.m_46467_();
        if (!blockEntity.isOnCooldown()) {
            blockEntity.setCooldown(0);
            UpperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> UpperBlockEntity.suckInItems(level, blockEntity));
        }
    }

    private static boolean tryMoveItems(Level level, BlockPos pos, BlockState state, UpperBlockEntity blockEntity, BooleanSupplier supplier) {
        if (level.f_46443_) {
            return false;
        }
        if (!blockEntity.isOnCooldown() && ((Boolean)state.m_61143_((Property)UpperBlock.ENABLED)).booleanValue()) {
            boolean flag = false;
            if (!blockEntity.m_7983_()) {
                flag = UpperBlockEntity.ejectItems(level, pos, state, blockEntity);
            }
            if (!blockEntity.inventoryFull()) {
                flag |= supplier.getAsBoolean();
            }
            if (flag) {
                blockEntity.setCooldown(8);
                UpperBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    private boolean inventoryFull() {
        for (ItemStack itemstack : this.items) {
            if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private static boolean ejectItems(Level level, BlockPos pos, BlockState state, UpperBlockEntity blockEntity) {
        if (InventoryCodeHooksTweaked.insertHook(blockEntity)) {
            return true;
        }
        Container container = UpperBlockEntity.getAttachedContainer(level, pos, state);
        if (container == null) {
            return false;
        }
        Direction direction = ((Direction)state.m_61143_((Property)UpperBlock.FACING)).m_122424_();
        if (UpperBlockEntity.isFullContainer(container, direction)) {
            return false;
        }
        for (int i = 0; i < blockEntity.m_6643_(); ++i) {
            if (blockEntity.m_8020_(i).m_41619_()) continue;
            ItemStack itemstack = blockEntity.m_8020_(i).m_41777_();
            ItemStack itemstack1 = UpperBlockEntity.addItem((Container)blockEntity, container, blockEntity.m_7407_(i, 1), direction);
            if (itemstack1.m_41619_()) {
                container.m_6596_();
                return true;
            }
            blockEntity.m_6836_(i, itemstack);
        }
        return false;
    }

    private static IntStream getSlots(Container inventoryIn, Direction direction) {
        return inventoryIn instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)inventoryIn).m_7071_(direction)) : IntStream.range(0, inventoryIn.m_6643_());
    }

    private static boolean isFullContainer(Container inventoryIn, Direction side) {
        return UpperBlockEntity.getSlots(inventoryIn, side).allMatch(stackInSlot -> {
            ItemStack itemstack = inventoryIn.m_8020_(stackInSlot);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    private static boolean isEmptyContainer(Container inventoryIn, Direction side) {
        return UpperBlockEntity.getSlots(inventoryIn, side).allMatch(stackInSlot -> inventoryIn.m_8020_(stackInSlot).m_41619_());
    }

    public static boolean suckInItems(Level level, IUpper upper) {
        Boolean ret = InventoryCodeHooksTweaked.extractHook(level, upper);
        if (ret != null) {
            return ret;
        }
        Container container = UpperBlockEntity.getSourceContainer(level, upper);
        if (container != null) {
            Direction direction = Direction.DOWN;
            return UpperBlockEntity.isEmptyContainer(container, direction) ? false : UpperBlockEntity.getSlots(container, direction).anyMatch(inventoryIn -> UpperBlockEntity.tryTakeInItemFromSlot(upper, container, inventoryIn, direction));
        }
        for (ItemEntity itementity : UpperBlockEntity.getItemsAtAndAbove(level, upper)) {
            if (!UpperBlockEntity.addItem((Container)upper, itementity)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryTakeInItemFromSlot(IUpper upper, Container inventoryIn, int index, Direction direction) {
        ItemStack itemstack = inventoryIn.m_8020_(index);
        if (!itemstack.m_41619_() && UpperBlockEntity.canTakeItemFromContainer(inventoryIn, itemstack, index, direction)) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack itemstack2 = UpperBlockEntity.addItem(inventoryIn, (Container)upper, inventoryIn.m_7407_(index, 1), null);
            if (itemstack2.m_41619_()) {
                inventoryIn.m_6596_();
                return true;
            }
            inventoryIn.m_6836_(index, itemstack1);
        }
        return false;
    }

    public static boolean addItem(Container destination, ItemEntity entity) {
        boolean flag = false;
        ItemStack itemstack = entity.m_32055_().m_41777_();
        ItemStack itemstack1 = UpperBlockEntity.addItem(null, destination, itemstack, null);
        if (itemstack1.m_41619_()) {
            flag = true;
            entity.m_146870_();
        } else {
            entity.m_32045_(itemstack1);
        }
        return flag;
    }

    protected IItemHandler createUnSidedHandler() {
        return new UpperItemHandler(this);
    }

    public static ItemStack addItem(@Nullable Container source, Container destination, ItemStack stack, @Nullable Direction direction) {
        if (destination instanceof WorldlyContainer && direction != null) {
            WorldlyContainer isidedinventory = (WorldlyContainer)destination;
            int[] aint = isidedinventory.m_7071_(direction);
            for (int k = 0; k < aint.length && !stack.m_41619_(); ++k) {
                stack = UpperBlockEntity.tryMoveInItem(source, destination, stack, aint[k], direction);
            }
        } else {
            int i = destination.m_6643_();
            for (int j = 0; j < i && !stack.m_41619_(); ++j) {
                stack = UpperBlockEntity.tryMoveInItem(source, destination, stack, j, direction);
            }
        }
        return stack;
    }

    private static boolean canPlaceItemInContainer(Container inventoryIn, ItemStack stack, int index, @Nullable Direction side) {
        if (!inventoryIn.m_7013_(index, stack)) {
            return false;
        }
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7155_(index, stack, side);
    }

    private static boolean canTakeItemFromContainer(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7157_(index, stack, side);
    }

    private static ItemStack tryMoveInItem(@Nullable Container source, Container destination, ItemStack stack, int index, @Nullable Direction direction) {
        ItemStack itemstack = destination.m_8020_(index);
        if (UpperBlockEntity.canPlaceItemInContainer(destination, stack, index, direction)) {
            boolean flag = false;
            boolean flag1 = destination.m_7983_();
            if (itemstack.m_41619_()) {
                destination.m_6836_(index, stack);
                stack = ItemStack.f_41583_;
                flag = true;
            } else if (UpperBlockEntity.canMergeItems(itemstack, stack)) {
                int i = stack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                UpperBlockEntity tileentityupper1;
                if (flag1 && destination instanceof UpperBlockEntity && !(tileentityupper1 = (UpperBlockEntity)destination).isOnCustomCooldown()) {
                    int k = 0;
                    if (source instanceof UpperBlockEntity) {
                        UpperBlockEntity tileentityupper = (UpperBlockEntity)source;
                        if (tileentityupper1.tickedGameTime >= tileentityupper.tickedGameTime) {
                            k = 1;
                        }
                    }
                    tileentityupper1.setCooldown(8 - k);
                }
                destination.m_6596_();
            }
        }
        return stack;
    }

    @Nullable
    private static Container getAttachedContainer(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)UpperBlock.FACING);
        return UpperBlockEntity.getContainerAt(level, pos.m_121945_(direction));
    }

    public static Container getSourceContainer(Level level, IUpper upper) {
        return UpperBlockEntity.getContainerAt(level, upper.m_6343_(), upper.m_6358_() - 1.0, upper.m_6446_());
    }

    public static List<ItemEntity> getItemsAtAndAbove(Level level, IUpper upper) {
        return upper.m_59300_().m_83299_().stream().flatMap(something -> level.m_6443_(ItemEntity.class, something.m_82386_(upper.m_6343_() - 0.5, upper.m_6358_() - 0.5, upper.m_6446_() - 0.5), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    @Nullable
    public static Container getContainerAt(Level level, BlockPos pos) {
        return UpperBlockEntity.getContainerAt(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    @Nullable
    public static Container getContainerAt(Level level, double x, double y, double z) {
        List list;
        BlockEntity tileentity;
        WorldlyContainer container = null;
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        BlockState state = level.m_8055_(blockpos);
        Block block = state.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)block).m_5840_(state, (LevelAccessor)level, blockpos);
        } else if (state.m_155947_() && (tileentity = level.m_7702_(blockpos)) instanceof Container && (container = (Container)tileentity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)state, (Level)level, (BlockPos)blockpos, (boolean)true);
        }
        if (container == null && !(list = level.m_6249_((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            container = (Container)list.get(level.f_46441_.m_188503_(list.size()));
        }
        return container;
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        if (stack1.m_41613_() > stack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2);
    }

    @Override
    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public void setCooldown(int ticks) {
        this.cooldownTime = ticks;
    }

    private boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    public boolean isOnCustomCooldown() {
        return this.cooldownTime > 8;
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new HopperMenu(id, inventory, (Container)this);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public static void entityInside(Level level, BlockPos pos, BlockState state, Entity entity, UpperBlockEntity blockEntity) {
        if (entity instanceof ItemEntity && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()))), (VoxelShape)blockEntity.m_59300_(), (BooleanOp)BooleanOp.f_82689_)) {
            UpperBlockEntity.tryMoveItems(level, pos, state, blockEntity, () -> UpperBlockEntity.addItem((Container)blockEntity, (ItemEntity)entity));
        }
    }

    public long getLastUpdateTime() {
        return this.tickedGameTime;
    }
}

