/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.armor.EffectImmunityModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.modules.ranged.RestrictAngleModule;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEvents {
    private static final String SOULBOUND_SLOT = "tic_soulbound_slot";
    private static final TinkerDataCapability.TinkerDataKey<Float> PROJECTILE_EXPERIENCE = TConstruct.createKey("projectile_experience");
    public static final ResourceLocation SOULBOUND = TConstruct.getResource("soulbound");

    @SubscribeEvent
    static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        Optional dataCap = entity.getCapability(TinkerDataCapability.CAPABILITY).resolve();
        double knockback = entity.m_21133_((Attribute)TinkerAttributes.KNOCKBACK_MULTIPLIER.get()) + (double)dataCap.map(data -> data.get(TinkerDataKeys.KNOCKBACK)).orElse(Float.valueOf(0.0f)).floatValue();
        if (knockback != 1.0) {
            event.setStrength((float)((double)event.getStrength() * knockback));
        }
        dataCap.ifPresent(data -> {
            int crystalbound = data.get(TinkerDataKeys.CRYSTALSTRIKE, 0);
            if (crystalbound > 0) {
                RestrictAngleModule.onKnockback(event, crystalbound);
            }
        });
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        double boost = entity.m_21133_((Attribute)TinkerAttributes.JUMP_BOOST.get()) + (double)ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0) {
            event.setDistance((float)Math.max((double)event.getDistance() - boost, 0.0));
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        double boost = entity.m_21133_((Attribute)TinkerAttributes.JUMP_BOOST.get()) + (double)ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, boost * 0.1, 0.0));
        }
    }

    @SubscribeEvent
    static void isPotionApplicable(MobEffectEvent.Applicable event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            if (((Multiset)data.computeIfAbsent(EffectImmunityModule.EFFECT_IMMUNITY)).contains((Object)event.getEffectInstance().m_19544_())) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity;
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity2;
        DamageSource source = event.getSource();
        if (source != null && (entity2 = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity2))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(PROJECTILE_EXPERIENCE, Float.valueOf(modifiers.getEntry(ModifierIds.experienced).getEffectiveLevel())));
        }
        if (!(entity = event.getEntity()).m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            boolean soulBelt = ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SOUL_BELT) > 0;
            Inventory inventory = player.m_150109_();
            int hotbarSize = Inventory.m_36059_();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !soulBelt && !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
            int totalSize = inventory.m_6643_();
            for (int i = hotbarSize; i < totalSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_(SOULBOUND_SLOT, i);
            }
        }
    }

    @SubscribeEvent
    static void beforeBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        double bonus = player.m_21133_((Attribute)TinkerAttributes.EXPERIENCE_MULTIPLIER.get()) + (double)((float)ModifierUtil.getModifierLevel(player.m_21205_(), ModifierIds.experienced) * 0.5f) + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.EXPERIENCE);
        event.setExpToDrop((int)((double)event.getExpToDrop() * bonus));
    }

    @SubscribeEvent
    static void onExperienceDrop(LivingExperienceDropEvent event) {
        float projectileBoost;
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = entity.m_21124_((MobEffect)TinkerEffects.experienced.get());
        double armorMultiplier = 1 + (instance != null ? instance.m_19564_() : 0);
        Player player = event.getAttackingPlayer();
        if (player != null) {
            armorMultiplier *= player.m_21133_((Attribute)TinkerAttributes.EXPERIENCE_MULTIPLIER.get()) + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.EXPERIENCE);
        }
        if ((projectileBoost = entity.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(PROJECTILE_EXPERIENCE)).orElse(Float.valueOf(-1.0f)).floatValue()) >= 0.0f) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * armorMultiplier + (double)projectileBoost * 0.5));
        } else if (player != null) {
            ToolStack tool = Modifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player));
            double multiplier = armorMultiplier + (double)(tool != null ? tool.getModifier(ModifierIds.experienced).getEffectiveLevel() : 0.0f) * 0.5;
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * multiplier));
        }
    }

    @SubscribeEvent
    static void onPlayerDropItems(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player) {
            Player player = (Player)entity;
            if (!(entity instanceof FakePlayer)) {
                Collection drops = event.getDrops();
                Iterator iter = drops.iterator();
                Inventory inventory = player.m_150109_();
                ArrayList<ItemEntity> takenSlot = new ArrayList<ItemEntity>();
                while (iter.hasNext()) {
                    ItemEntity itemEntity = (ItemEntity)iter.next();
                    ItemStack stack = itemEntity.m_32055_();
                    CompoundTag tag = stack.m_41783_();
                    if (tag == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
                    int slot = tag.m_128451_(SOULBOUND_SLOT);
                    if (inventory.m_8020_(slot).m_41619_()) {
                        inventory.m_6836_(slot, stack);
                    } else {
                        takenSlot.add(itemEntity);
                    }
                    iter.remove();
                }
                for (ItemEntity itemEntity : takenSlot) {
                    ItemStack stack = itemEntity.m_32055_();
                    if (inventory.m_36054_(stack)) continue;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null) {
                        tag.m_128473_(SOULBOUND_SLOT);
                        if (tag.m_128456_()) {
                            stack.m_41751_(null);
                        }
                    }
                    drops.add(itemEntity);
                }
            }
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (clone.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || original.m_5833_()) {
            return;
        }
        Inventory originalInv = original.m_150109_();
        Inventory cloneInv = clone.m_150109_();
        int size = Math.min(originalInv.m_6643_(), cloneInv.m_6643_());
        for (int i = 0; i < size; ++i) {
            CompoundTag tag;
            ItemStack stack = originalInv.m_8020_(i);
            if (stack.m_41619_() || (tag = stack.m_41783_()) == null || !tag.m_128425_(SOULBOUND_SLOT, 99)) continue;
            cloneInv.m_6836_(i, stack);
            tag.m_128473_(SOULBOUND_SLOT);
            if (!tag.m_128456_()) continue;
            stack.m_41751_(null);
        }
    }

    @SubscribeEvent
    static void onCritical(CriticalHitEvent event) {
        Attribute attribute;
        Player living;
        double criticalBoost;
        if (event.getResult() != Event.Result.DENY && (criticalBoost = (living = event.getEntity()).m_21133_(attribute = (Attribute)TinkerAttributes.CRITICAL_DAMAGE.get()) - attribute.m_22082_() + (double)ArmorStatModule.getStat((Entity)living, TinkerDataKeys.CRITICAL_DAMAGE)) > 0.0) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && TinkerPredicate.AIRBORNE.matches((Object)living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier((float)((double)event.getDamageModifier() + criticalBoost));
            }
        }
    }

    @SubscribeEvent
    static void onPotionStart(MobEffectEvent.Added event) {
        MobEffectInstance newEffect = event.getEffectInstance();
        if (!newEffect.getCurativeItems().isEmpty()) {
            boolean beneficial = newEffect.m_19544_().m_19486_();
            LivingEntity entity = event.getEntity();
            double multiplier = entity.m_21133_(beneficial ? (Attribute)TinkerAttributes.GOOD_EFFECT_DURATION.get() : (Attribute)TinkerAttributes.BAD_EFFECT_DURATION.get()) + (double)ArmorStatModule.getStat((Entity)entity, beneficial ? TinkerDataKeys.GOOD_EFFECT_DURATION : TinkerDataKeys.BAD_EFFECT_DURATION);
            if (multiplier != 1.0) {
                int duration = (int)((double)newEffect.m_19557_() * multiplier);
                if (duration < 0) {
                    duration = 0;
                }
                newEffect.f_19503_ = duration;
            }
        }
    }

    @SubscribeEvent
    static void bounceOnFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living == null || living.m_20184_().f_82480_ > -0.3 && living.f_19789_ < 3.0f) {
            return;
        }
        if (living.m_21133_((Attribute)TinkerAttributes.BOUNCY.get()) < 1.0) {
            return;
        }
        if (living.m_20162_()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        Vec3 motion = living.m_20184_();
        if (living instanceof ServerPlayer) {
            double gravity = living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double time = Math.sqrt((double)living.f_19789_ / gravity);
            double velocity = gravity * time;
            living.m_20334_(motion.f_82479_ / (double)0.975f, velocity, motion.f_82481_ / (double)0.975f);
            living.f_19864_ = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            float factor = living.f_19789_ < 2.0f ? -0.7f : -0.9f;
            living.m_20334_(motion.f_82479_ / (double)0.975f, motion.f_82480_ * (double)factor, motion.f_82481_ / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living, living.m_20184_());
        }
        event.setDistance(0.0f);
        if (!living.m_9236_().f_46443_) {
            living.f_19812_ = true;
            event.setCanceled(true);
            living.m_6853_(false);
        }
        living.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
    }
}

