/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.weapon;

import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.weapon.MeleeHitToolHook;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.upgrades.melee.SweepingEdgeModifier;

public record SweepWeaponAttack(float range) implements MeleeHitToolHook,
ToolModule
{
    public static final RecordLoadable<SweepWeaponAttack> LOADER = RecordLoadable.create((RecordField)FloatLoadable.FROM_ZERO.defaultField("range", (Object)Float.valueOf(0.0f), true, SweepWeaponAttack::range), SweepWeaponAttack::new);
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolHooks.MELEE_HIT);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<SweepWeaponAttack> getLoader() {
        return LOADER;
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ToolAttackContext context, float damage) {
        LivingEntity attacker = context.getAttacker();
        if (context.isFullyCharged() && !attacker.m_20142_() && !context.isCritical() && attacker.m_20096_() && attacker.f_19787_ - attacker.f_19867_ < attacker.m_6113_()) {
            double range = this.range + (float)tool.getModifierLevel(TinkerModifiers.expanded.getId());
            double rangeSq = 2.0 + range;
            rangeSq *= rangeSq;
            float sweepDamage = ((SweepingEdgeModifier)TinkerModifiers.sweeping.get()).getSweepingDamage(tool, damage);
            Entity target = context.getTarget();
            Level level = attacker.m_9236_();
            for (LivingEntity aoeTarget : level.m_45976_(LivingEntity.class, target.m_20191_().m_82377_(range, 0.25, range))) {
                ArmorStand armorStand;
                if (aoeTarget == attacker || aoeTarget == target || attacker.m_7307_((Entity)aoeTarget) || aoeTarget instanceof ArmorStand && (armorStand = (ArmorStand)aoeTarget).m_31677_() || !(attacker.m_20280_((Entity)aoeTarget) < rangeSq)) continue;
                float angle = attacker.m_146908_() * ((float)Math.PI / 180);
                aoeTarget.m_147240_((double)0.4f, (double)Mth.m_14031_((float)angle), (double)(-Mth.m_14089_((float)angle)));
                ToolAttackUtil.dealDefaultDamage(attacker, (Entity)aoeTarget, sweepDamage);
            }
            level.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12317_, attacker.m_5720_(), 1.0f, 1.0f);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_36346_();
            }
        }
    }
}

