/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.registry.IdAwareComponentRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolActionToolHook;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolStatsHook;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitHook;
import slimeknights.tconstruct.library.tools.definition.module.build.VolatileDataToolHook;
import slimeknights.tconstruct.library.tools.definition.module.interaction.InteractionToolModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairToolHook;
import slimeknights.tconstruct.library.tools.definition.module.material.MissingMaterialsToolHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningSpeedToolHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningTierToolHook;
import slimeknights.tconstruct.library.tools.definition.module.weapon.MeleeHitToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;

public class ToolHooks {
    public static final IdAwareComponentRegistry<ModuleHook<?>> LOADER = new IdAwareComponentRegistry("Unknown Tool Hook");
    public static final ModuleHook<ToolMaterialHook> TOOL_MATERIALS = ToolHooks.register("tool_materials", ToolMaterialHook.class, definition -> List.of());
    public static final ModuleHook<ToolPartsHook> TOOL_PARTS = ToolHooks.register("tool_parts", ToolPartsHook.class, definition -> List.of());
    public static final ModuleHook<MissingMaterialsToolHook> MISSING_MATERIALS = ToolHooks.register("missing_materials", MissingMaterialsToolHook.class, (definition, random) -> {
        MaterialNBT.Builder builder = MaterialNBT.builder();
        for (MaterialStatsId statType : ToolMaterialHook.stats(definition)) {
            builder.add(MaterialRegistry.firstWithStatType(statType));
        }
        return builder.build();
    });
    public static final ModuleHook<MaterialRepairToolHook> MATERIAL_REPAIR = ToolHooks.register("material_repair", MaterialRepairToolHook.class, MaterialRepairToolHook.MaxMerger::new, new MaterialRepairToolHook(){

        @Override
        public boolean isRepairMaterial(IToolStackView tool, MaterialId material) {
            return false;
        }

        @Override
        public float getRepairAmount(IToolStackView tool, MaterialId material) {
            return 0.0f;
        }
    });
    public static final ModuleHook<ToolStatsHook> TOOL_STATS = ToolHooks.register("tool_stats", ToolStatsHook.class, ToolStatsHook.AllMerger::new, (context, builder) -> {});
    public static final ModuleHook<VolatileDataToolHook> VOLATILE_DATA = ToolHooks.register("volatile_data", VolatileDataToolHook.class, VolatileDataToolHook.AllMerger::new, (context, data) -> {});
    public static final ModuleHook<ToolTraitHook> TOOL_TRAITS;
    public static final ModuleHook<ToolTraitHook> REBALANCED_TRAIT;
    public static final ModuleHook<ToolActionToolHook> TOOL_ACTION;
    public static final ModuleHook<IsEffectiveToolHook> IS_EFFECTIVE;
    public static final ModuleHook<MiningTierToolHook> MINING_TIER;
    public static final ModuleHook<MiningSpeedToolHook> MINING_SPEED;
    public static final ModuleHook<AreaOfEffectIterator> AOE_ITERATOR;
    public static final ModuleHook<MeleeHitToolHook> MELEE_HIT;
    public static final ModuleHook<InteractionToolModule> INTERACTION;

    private ToolHooks() {
    }

    public static void init() {
    }

    public static <T> ModuleHook<T> register(ResourceLocation name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return (ModuleHook)LOADER.register(new ModuleHook<T>(name, filter, merger, defaultInstance));
    }

    public static <T> ModuleHook<T> register(ResourceLocation name, Class<T> filter, T defaultInstance) {
        return ToolHooks.register(name, filter, null, defaultInstance);
    }

    private static <T> ModuleHook<T> register(String name, Class<T> filter, @Nullable Function<Collection<T>, T> merger, T defaultInstance) {
        return ToolHooks.register(TConstruct.getResource(name), filter, merger, defaultInstance);
    }

    private static <T> ModuleHook<T> register(String name, Class<T> filter, T defaultInstance) {
        return ToolHooks.register(name, filter, null, defaultInstance);
    }

    static {
        Function<Collection, ToolTraitHook> merger = ToolTraitHook.AllMerger::new;
        ToolTraitHook defaultInstance = (definition, materials, builder) -> {};
        TOOL_TRAITS = ToolHooks.register("tool_traits", ToolTraitHook.class, merger, defaultInstance);
        REBALANCED_TRAIT = ToolHooks.register("rebalanced_trait", ToolTraitHook.class, merger, defaultInstance);
        TOOL_ACTION = ToolHooks.register("tool_actions", ToolActionToolHook.class, ToolActionToolHook.AnyMerger::new, (tool, action) -> false);
        IS_EFFECTIVE = ToolHooks.register("is_effective", IsEffectiveToolHook.class, (tool, state) -> false);
        MINING_TIER = ToolHooks.register("mining_tier", MiningTierToolHook.class, MiningTierToolHook.ComposeMerger::new, (tool, tier) -> tier);
        MINING_SPEED = ToolHooks.register("mining_speed_modifier", MiningSpeedToolHook.class, MiningSpeedToolHook.ComposeMerger::new, (tool, state, speed) -> speed);
        AOE_ITERATOR = ToolHooks.register("aoe_iterator", AreaOfEffectIterator.class, (tool, context, state, match) -> Collections.emptyList());
        MELEE_HIT = ToolHooks.register("after_melee_hit", MeleeHitToolHook.class, MeleeHitToolHook.AllMerger::new, (tool, context, damage) -> {});
        INTERACTION = ToolHooks.register("tool_interaction", InteractionToolModule.class, (t, m, s) -> true);
    }
}

