/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.data.ModifierIds;

public record ProtectionModule(IJsonPredicate<DamageSource> source, IJsonPredicate<LivingEntity> entity, IJsonPredicate<LivingEntity> attacker, LevelingValue amount, ModifierCondition<IToolStackView> condition) implements ProtectionModifierHook,
TooltipModifierHook,
ModifierModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROTECTION, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<ProtectionModule> LOADER = RecordLoadable.create((RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", ProtectionModule::source), (RecordField)LivingEntityPredicate.LOADER.defaultField("wearing_entity", ProtectionModule::entity), (RecordField)LivingEntityPredicate.LOADER.defaultField("attacker", ProtectionModule::attacker), (RecordField)LevelingValue.LOADABLE.directField(ProtectionModule::amount), ModifierCondition.TOOL_FIELD, ProtectionModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        LivingEntity living;
        Entity entity;
        if (this.condition.matches(tool, modifier) && this.source.matches((Object)source) && this.entity.matches((Object)context.getEntity()) && (this.attacker == LivingEntityPredicate.ANY || (entity = source.m_7639_()) instanceof LivingEntity && this.attacker.matches((Object)(living = (LivingEntity)entity)))) {
            modifierValue += this.amount.compute(modifier.getEffectiveLevel());
        }
        return modifierValue;
    }

    public static void addResistanceTooltip(IToolStackView tool, Modifier modifier, float amount, @Nullable Player player, List<Component> tooltip) {
        double cap = player != null ? ProtectionModifierHook.getProtectionCap((LivingEntity)player) : (double)Math.min(20.0f + (float)tool.getModifierLevel(ModifierIds.boundless) * 2.5f, 19.0f);
        tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)Util.PERCENT_BOOST_FORMAT.format(Math.min((double)amount, cap) / 25.0)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".resistance")))));
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.condition.matches(tool, modifier) && TinkerPredicate.matchesInTooltip(this.entity, (LivingEntity)player, tooltipKey)) {
            ProtectionModule.addResistanceTooltip(tool, modifier.getModifier(), this.amount.compute(modifier.getEffectiveLevel()), player, tooltip);
        }
    }

    public RecordLoadable<ProtectionModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<ProtectionModule> {
        private IJsonPredicate<DamageSource> source = DamageSourcePredicate.CAN_PROTECT;
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;

        private Builder() {
        }

        @SafeVarargs
        public final Builder sources(IJsonPredicate<DamageSource> ... sources) {
            return this.source((IJsonPredicate<DamageSource>)DamageSourcePredicate.and(sources));
        }

        @Override
        public ProtectionModule amount(float flat, float eachLevel) {
            return new ProtectionModule(this.source, this.entity, this.attacker, new LevelingValue(flat, eachLevel), this.condition);
        }

        public Builder source(IJsonPredicate<DamageSource> source) {
            this.source = source;
            return this;
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }
    }
}

