/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FiniteFluid
extends Fluid {
    public static final IntegerProperty LEVEL = ModBlockProperties.FINITE_FLUID_LEVEL;
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();
    protected final int maxLayers;
    private final Supplier<? extends BucketItem> bucket;
    private final Supplier<? extends Block> block;

    public FiniteFluid(int maxLayers, Supplier<? extends Block> block, Supplier<? extends BucketItem> bucket) {
        this.maxLayers = maxLayers;
        this.block = block;
        this.bucket = bucket;
        this.m_76142_((FluidState)((FluidState)this.f_76105_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(maxLayers)));
    }

    public int getLayersPerBlock() {
        return this.maxLayers;
    }

    public Item m_6859_() {
        return (Item)this.bucket.get();
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public Vec3 m_7000_(BlockGetter blockReader, BlockPos pos, FluidState fluidState) {
        return Vec3.f_82478_;
    }

    /*
     * WARNING - void declaration
     */
    private void spreadToSides(Level level, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int currentAmount = fluidState.m_76186_();
        if (currentAmount > 1) {
            Map<Direction, Integer> map = this.getWantedSpreadDirections((BlockGetter)level, pos, blockState);
            ArrayList<Map.Entry<Direction, Integer>> entryList = new ArrayList<Map.Entry<Direction, Integer>>(map.entrySet());
            Collections.shuffle(entryList);
            map = new LinkedHashMap<Direction, Integer>();
            for (Map.Entry entry : entryList) {
                map.put((Direction)entry.getKey(), (Integer)entry.getValue());
            }
            int initialAmount = currentAmount;
            map.values().removeIf(i -> i >= initialAmount);
            boolean bl = true;
            block1: while (currentAmount <= map.size()) {
                void var9_12;
                void finalR = var9_12++;
                Iterator<Map.Entry<Direction, Integer>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Direction, Integer> e = iter.next();
                    if (e.getValue() > initialAmount - finalR) {
                        iter.remove();
                    }
                    if (currentAmount <= map.size()) continue;
                    continue block1;
                }
            }
            for (Map.Entry<Direction, Integer> e : map.entrySet()) {
                int oldAmount = e.getValue();
                Direction dir = e.getKey();
                BlockPos facingPos = pos.m_121945_(dir);
                BlockState s = level.m_8055_(facingPos);
                FluidState fluidstate = this.makeState(oldAmount + 1);
                this.spreadTo((LevelAccessor)level, facingPos, s, dir, fluidstate);
            }
            if (!map.isEmpty()) {
                FluidState myNewState = this.makeState(currentAmount - map.size());
                BlockState blockstate = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)((Integer)myNewState.m_76188_().m_61143_((Property)BlockStateProperties.f_61422_)));
                level.m_7731_(pos, blockstate, 2);
                level.m_46672_(pos, blockstate.m_60734_());
            }
        }
    }

    public FluidState makeState(int level) {
        return (FluidState)this.m_76145_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level));
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer container = (LiquidBlockContainer)block;
            container.m_7361_(level, pos, blockState, fluidState);
        } else if (blockState.m_60819_().m_192917_((Fluid)this)) {
            level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)((Integer)fluidState.m_76188_().m_61143_((Property)BlockStateProperties.f_61422_))), 3);
        } else {
            if (!blockState.m_60795_()) {
                this.beforeDestroyingBlock(level, pos, blockState);
            }
            level.m_7731_(pos, fluidState.m_76188_(), 3);
        }
    }

    protected Map<Direction, Integer> getWantedSpreadDirections(BlockGetter level, BlockPos pos, BlockState state) {
        HashMap<Direction, Integer> list = new HashMap<Direction, Integer>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos facingPos = pos.m_121945_(direction);
            BlockState facingState = level.m_8055_(facingPos);
            FluidState facingFluid = facingState.m_60819_();
            if (!this.canHoldFluid(level, facingPos, facingState)) continue;
            list.put(direction, facingFluid.m_76186_());
        }
        return list;
    }

    public void m_6292_(Level level, BlockPos pos, FluidState state) {
        if (state.m_76178_()) {
            return;
        }
        BlockState myState = level.m_8055_(pos);
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        FluidState belowFluid = belowState.m_60819_();
        if (belowFluid.m_76152_().m_6212_((Fluid)this)) {
            if (belowFluid.m_76186_() < this.maxLayers) {
                int belowMissing = this.maxLayers - belowFluid.m_76186_();
                int belowAddition = Math.min(belowMissing, state.m_76186_());
                int newAboveAmount = state.m_76186_() - belowAddition;
                level.m_46597_(belowPos, ((FluidState)belowFluid.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(belowFluid.m_76186_() + belowAddition))).m_76188_());
                if (newAboveAmount > 0) {
                    level.m_46597_(pos, ((FluidState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(newAboveAmount))).m_76188_());
                } else {
                    level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
            } else {
                this.spreadToSides(level, pos, state, myState);
            }
            return;
        }
        if (this.canHoldFluid((BlockGetter)level, belowPos, belowState)) {
            this.spreadTo((LevelAccessor)level, belowPos, belowState, Direction.DOWN, state);
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        } else {
            this.spreadToSides(level, pos, state, myState);
        }
    }

    private boolean canHoldFluid(BlockGetter level, BlockPos pos, BlockState state) {
        FluidState fluidState = state.m_60819_();
        if (!fluidState.m_76178_() && !fluidState.m_192917_((Fluid)this)) {
            return false;
        }
        Block block = state.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer lc = (LiquidBlockContainer)block;
            return lc.m_6044_(level, pos, state, (Fluid)this);
        }
        if (!(block instanceof DoorBlock || state.m_204336_(BlockTags.f_13068_) || state.m_60713_(Blocks.f_50155_) || state.m_60713_(Blocks.f_50130_) || state.m_60713_(Blocks.f_50628_) || state.m_60713_(Blocks.f_50142_) || state.m_60713_(Blocks.f_50257_) || state.m_60713_(Blocks.f_50446_) || state.m_60713_(Blocks.f_50454_))) {
            return !state.m_280555_();
        }
        return false;
    }

    private static boolean hasSameAbove(FluidState fluidState, BlockGetter level, BlockPos pos) {
        return fluidState.m_76152_().m_6212_(level.m_6425_(pos.m_7494_()).m_76152_());
    }

    public float m_6098_(FluidState state, BlockGetter level, BlockPos pos) {
        return FiniteFluid.hasSameAbove(state, level, pos) ? 1.0f : state.m_76182_();
    }

    public float m_7427_(FluidState state) {
        return 0.875f * (float)state.m_76186_() / (float)this.maxLayers;
    }

    public boolean m_7444_(FluidState state) {
        return true;
    }

    public int m_7430_(FluidState state) {
        return (Integer)state.m_61143_((Property)LEVEL);
    }

    public VoxelShape m_7999_(FluidState state, BlockGetter level, BlockPos pos) {
        return this.shapes.computeIfAbsent(state, arg3 -> Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)arg3.m_76155_(level, pos), (double)1.0));
    }

    public boolean shouldSlowDown(FluidState state) {
        return state.m_76186_() > 2;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        Block.m_49892_((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return true;
    }

    public int m_6718_(LevelReader level) {
        return 5;
    }

    protected float m_6752_() {
        return 0.0f;
    }

    protected BlockState m_5804_(FluidState state) {
        return (BlockState)this.block.get().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(this.getLegacyLevel(state)));
    }

    protected int getLegacyLevel(FluidState state) {
        int amount = state.m_76186_();
        return this.maxLayers - Math.min(amount, this.maxLayers);
    }
}

