/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.codexadrian.tempad.common.entity.TimedoorEntity;
import me.codexadrian.tempad.common.utils.ShaderUtils;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TimedoorRenderer
extends EntityRenderer<TimedoorEntity> {
    private static final int uv00 = LightTexture.m_109885_((int)0, (int)0);
    private static final int uv01 = LightTexture.m_109885_((int)0, (int)1);
    private static final int uv10 = LightTexture.m_109885_((int)1, (int)0);
    private static final int uv11 = LightTexture.m_109885_((int)1, (int)1);

    public TimedoorRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TimedoorEntity entity, float yaw, float deltaTime, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int light) {
        float width = 1.4f;
        float height = 2.3f;
        float depth = 0.4f;
        int closingTime = entity.getClosingTime();
        int tickLength = 8;
        int phaseLength = tickLength / 2;
        int ticks = entity.f_19797_;
        float animation = ((float)ticks + deltaTime) / (float)tickLength;
        if (ticks < phaseLength) {
            width = Mth.m_14179_((float)(animation * 2.0f), (float)0.0f, (float)width);
            height = 0.2f;
        }
        if (ticks >= phaseLength && ticks < tickLength) {
            height = Mth.m_14179_((float)((animation - 0.5f) * 2.0f), (float)0.2f, (float)height);
        }
        if (closingTime != -1) {
            if (ticks > closingTime && ticks < closingTime + phaseLength) {
                height = Mth.m_14179_((float)(1.0f - (animation - (float)closingTime / (float)tickLength) * 2.0f), (float)0.2f, (float)height);
            }
            if (ticks >= closingTime + phaseLength) {
                width = Mth.m_14179_((float)(1.0f - (animation - (float)closingTime / (float)tickLength - 0.5f) * 2.0f), (float)0.0f, (float)width);
                height = 0.2f;
            }
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(entity.m_146908_()));
        poseStack.m_252880_(0.0f, 1.15f, 0.0f);
        Matrix4f model = poseStack.m_85850_().m_252922_();
        if (width >= 0.0f) {
            this.renderTimedoor(model, multiBufferSource, width, height, depth, light, entity.getColor());
        }
        super.m_7392_((Entity)entity, yaw, deltaTime, poseStack, multiBufferSource, light);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull TimedoorEntity entity) {
        return new ResourceLocation("tempad", "");
    }

    public void renderTimedoor(Matrix4f model, MultiBufferSource multiBufferSource, float width, float height, float depth, int i, int color) {
        float xBound = width * 0.5f;
        float yBound = height * 0.5f;
        float zBound = depth * -0.5f;
        float xBoundN = -xBound;
        float yBoundN = -yBound;
        float zBoundP = -zBound;
        VertexConsumer buffer = multiBufferSource.m_6299_(ShaderUtils.getTimedoorShaderType());
        float red = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 1.0f;
        buffer.m_252986_(model, xBoundN, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv10).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBoundN, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, yBound).m_85969_(uv10).m_5752_();
        buffer.m_252986_(model, xBoundN, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBoundN, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv10).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(xBound, zBoundP).m_85969_(uv10).m_5752_();
        buffer.m_252986_(model, xBoundN, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBoundN, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBoundN, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv10).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv00).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBoundP).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv01).m_5752_();
        buffer.m_252986_(model, xBound, yBoundN, zBound).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv11).m_5752_();
        buffer.m_252986_(model, xBound, yBound, zBound).m_85950_(red, green, blue, alpha).m_7421_(zBoundP, yBound).m_85969_(uv10).m_5752_();
    }
}

