/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.customization.shape.ChoicesShape;
import snownee.kiwi.customization.shape.ConfigureCrossCollisionShape;
import snownee.kiwi.customization.shape.ConfigureWallShape;
import snownee.kiwi.customization.shape.DirectionalShape;
import snownee.kiwi.customization.shape.FrontAndTopShape;
import snownee.kiwi.customization.shape.HorizontalShape;
import snownee.kiwi.customization.shape.MouldingShape;
import snownee.kiwi.customization.shape.ShapeRef;
import snownee.kiwi.customization.shape.SixWayShape;
import snownee.kiwi.customization.shape.UnbakedShape;

public class UnbakedShapeCodec
implements Codec<UnbakedShape> {
    private final Pattern simpleShapePattern = Pattern.compile("\\((-?\\d+\\.?\\d*)d?,(-?\\d+\\.?\\d*)d?,(-?\\d+\\.?\\d*)d?,(-?\\d+\\.?\\d*)d?,(-?\\d+\\.?\\d*)d?,(-?\\d+\\.?\\d*)d?\\)");
    private final Map<String, BooleanOp> booleanOpMap = Map.ofEntries(Map.entry("and", BooleanOp.f_82689_), Map.entry("or", BooleanOp.f_82695_), Map.entry("not_or", BooleanOp.f_82682_), Map.entry("not_and", BooleanOp.f_82688_), Map.entry("only_first", BooleanOp.f_82685_), Map.entry("only_second", BooleanOp.f_82683_), Map.entry("not_same", BooleanOp.f_82687_), Map.entry("same", BooleanOp.f_82690_), Map.entry("causes", BooleanOp.f_82692_), Map.entry("caused_by", BooleanOp.f_82694_));
    private final Map<String, Codec<? extends UnbakedShape>> typedCodecMap;
    private final Map<ResourceLocation, ShapeRef> refInterner = Maps.newHashMap();

    public UnbakedShapeCodec() {
        this.typedCodecMap = Map.ofEntries(Map.entry("directional", DirectionalShape.Unbaked.codec(this)), Map.entry("horizontal", HorizontalShape.Unbaked.codec(this)), Map.entry("choices", ChoicesShape.Unbaked.codec(this)), Map.entry("moulding", MouldingShape.Unbaked.codec(this)), Map.entry("six_way", SixWayShape.Unbaked.codec(this)), Map.entry("front_and_top", FrontAndTopShape.Unbaked.codec(this)), Map.entry("configure_wall", ConfigureWallShape.codec()), Map.entry("configure_cross_collision", ConfigureCrossCollisionShape.codec()));
    }

    public <T> DataResult<Pair<UnbakedShape, T>> decode(DynamicOps<T> ops, T input) {
        try {
            return DataResult.success((Object)Pair.of((Object)this.directDecode(ops, input), input));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }

    public <T> DataResult<T> encode(UnbakedShape input, DynamicOps<T> ops, T prefix) {
        throw new NotImplementedException();
    }

    public <T> UnbakedShape directDecode(DynamicOps<T> ops, T input) {
        Optional stringValue = ops.getStringValue(input).result();
        if (stringValue.isPresent()) {
            return this.decodeVoxelShape((String)stringValue.get());
        }
        Optional mapValue = ops.getMap(input).result();
        if (mapValue.isPresent()) {
            DataResult typeResult = ops.getStringValue(((MapLike)mapValue.get()).get("type"));
            if (typeResult.error().isPresent()) {
                throw new IllegalArgumentException("No \"type\" in shape object " + input);
            }
            String type = (String)typeResult.result().orElseThrow();
            Codec<? extends UnbakedShape> codec = this.typedCodecMap.get(type);
            if (codec == null) {
                throw new IllegalArgumentException("Unknown shape type " + type);
            }
            DataResult result = codec.decode(ops, input);
            if (result.error().isPresent()) {
                throw new IllegalArgumentException(((DataResult.PartialResult)result.error().get()).message());
            }
            return result.result().map(Pair::getFirst).orElseThrow();
        }
        throw new IllegalArgumentException("Shape must be a string or an object " + input);
    }

    private UnbakedShape decodeVoxelShape(String s) {
        if ((s = StringUtils.deleteWhitespace((String)s).toLowerCase(Locale.ENGLISH)).isEmpty()) {
            throw new IllegalArgumentException("Empty shape string");
        }
        if (ResourceLocation.m_135830_((String)s) && s.indexOf(40) == -1 && s.indexOf(44) == -1) {
            return this.refInterner.computeIfAbsent(new ResourceLocation(s), ShapeRef::new);
        }
        return new UnbakedShape.Inlined(this.recursiveDecodeVoxelShape(s));
    }

    private VoxelShape recursiveDecodeVoxelShape(String s) {
        Matcher matcher;
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Empty shape string in parameters");
        }
        if (s.endsWith(")")) {
            BooleanOp booleanOp;
            int leftBracket = s.indexOf(40);
            BooleanOp booleanOp2 = booleanOp = leftBracket > 1 ? this.booleanOpMap.get(s.substring(0, leftBracket)) : null;
            if (booleanOp != null) {
                String s1 = s.substring(leftBracket + 1, s.length() - 1);
                int expectedRightBrackets = 0;
                int comma = -1;
                for (int j = 0; j < s1.length(); ++j) {
                    char c = s1.charAt(j);
                    if (c == '(') {
                        ++expectedRightBrackets;
                        continue;
                    }
                    if (c == ')') {
                        --expectedRightBrackets;
                        continue;
                    }
                    if (c != ',' || expectedRightBrackets != 0) continue;
                    if (comma >= 0) {
                        throw new IllegalArgumentException("Multiple commas in a shape boolean function");
                    }
                    comma = j;
                }
                if (expectedRightBrackets != 0) {
                    throw new IllegalArgumentException("Unmatched brackets in a shape boolean function");
                }
                if (comma == -1) {
                    throw new IllegalArgumentException("No comma in a shape boolean function");
                }
                VoxelShape left = this.recursiveDecodeVoxelShape(s1.substring(0, comma));
                VoxelShape right = this.recursiveDecodeVoxelShape(s1.substring(comma + 1));
                return Shapes.m_83113_((VoxelShape)left, (VoxelShape)right, (BooleanOp)booleanOp);
            }
        }
        if (!(matcher = this.simpleShapePattern.matcher(s)).find()) {
            throw new IllegalArgumentException("Invalid shape string: " + s);
        }
        VoxelShape shape = Shapes.m_83040_();
        do {
            double x1 = Double.parseDouble(matcher.group(1));
            double y1 = Double.parseDouble(matcher.group(2));
            double z1 = Double.parseDouble(matcher.group(3));
            double x2 = Double.parseDouble(matcher.group(4));
            double y2 = Double.parseDouble(matcher.group(5));
            double z2 = Double.parseDouble(matcher.group(6));
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2), (BooleanOp)BooleanOp.f_82695_);
        } while (matcher.find());
        return shape.m_83296_();
    }

    public static String encodeVoxelShape(VoxelShape shape) {
        DecimalFormat format = new DecimalFormat("0.###");
        StringBuilder builder = new StringBuilder();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            if (!builder.isEmpty()) {
                builder.append('\n');
            }
            builder.append('(').append(format.format(x1 * 16.0)).append(", ").append(format.format(y1 * 16.0)).append(", ").append(format.format(z1 * 16.0)).append(", ").append(format.format(x2 * 16.0)).append(", ").append(format.format(y2 * 16.0)).append(", ").append(format.format(z2 * 16.0)).append(')');
        });
        return builder.toString();
    }
}

