/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.Block;
import snownee.kiwi.customization.builder.BuilderRule;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.resource.OneTimeLoader;

public class BuilderRules {
    private static ImmutableListMultimap<Block, KHolder<BuilderRule>> byBlock = ImmutableListMultimap.of();
    private static ImmutableMap<ResourceLocation, KHolder<BuilderRule>> byId = ImmutableMap.of();

    public static Collection<KHolder<BuilderRule>> find(Block block) {
        return byBlock.get((Object)block);
    }

    public static int reload(ResourceManager resourceManager, OneTimeLoader.Context context) {
        Map<ResourceLocation, BuilderRule> families = OneTimeLoader.load(resourceManager, "kiwi/builder_rule", BuilderRule.CODEC, context);
        byId = (ImmutableMap)families.entrySet().stream().map(e -> new KHolder<BuilderRule>((ResourceLocation)e.getKey(), (BuilderRule)e.getValue())).collect(ImmutableMap.toImmutableMap(KHolder::key, Function.identity()));
        ImmutableListMultimap.Builder byBlockBuilder = ImmutableListMultimap.builder();
        for (KHolder holder : byId.values()) {
            ((BuilderRule)holder.value()).relatedBlocks().forEach(block -> byBlockBuilder.put(block, (Object)holder));
        }
        byBlock = byBlockBuilder.build();
        return byId.size();
    }

    public static BuilderRule get(ResourceLocation id) {
        KHolder holder = (KHolder)byId.get((Object)id);
        return holder == null ? null : (BuilderRule)holder.value();
    }

    public static Collection<KHolder<BuilderRule>> all() {
        return byId.values();
    }
}

