/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.endimator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamabnormals.blueprint.core.endimator.EndimatablePart;
import com.teamabnormals.blueprint.core.endimator.model.EndimatorPartPose;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class EndimatorModelPart
extends ModelPart
implements EndimatablePart {
    public float xOffset;
    public float yOffset;
    public float zOffset;
    public boolean scaleChildren = true;
    public EndimatorPartPose initialPartPose = new EndimatorPartPose();

    public EndimatorModelPart(List<ModelPart.Cube> cubes, Map<String, ModelPart> children) {
        super(cubes, children);
    }

    public EndimatorModelPart(ModelPart part) {
        this(part.f_104212_, part.f_104213_);
        this.m_104315_(part);
        this.setInitialPose(new EndimatorPartPose().setPartPose(part.m_233566_()));
    }

    public EndimatorModelPart(ModelPart part, float xOffset, float yOffset, float zOffset, float xScale, float yScale, float zScale, boolean scaleChildren) {
        this(part.f_104212_, part.f_104213_);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.f_233553_ = xScale;
        this.f_233554_ = yScale;
        this.f_233555_ = zScale;
        this.scaleChildren = scaleChildren;
    }

    public EndimatorModelPart(ModelPart part, float xOffset, float yOffset, float zOffset) {
        this(part.f_104212_, part.f_104213_);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public EndimatorModelPart(ModelPart part, float xScale, float yScale, float zScale, boolean scaleChildren) {
        this(part.f_104212_, part.f_104213_);
        this.f_233553_ = xScale;
        this.f_233554_ = yScale;
        this.f_233555_ = zScale;
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float x, float y, float z) {
        this.f_233553_ = x;
        this.f_233554_ = y;
        this.f_233555_ = z;
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setOffset(float x, float y, float z) {
        this.xOffset = x;
        this.yOffset = y;
        this.zOffset = z;
    }

    public void m_233569_() {
        this.loadPose(this.initialPartPose);
    }

    @Override
    public void reset() {
        this.m_233569_();
    }

    public void m_104306_(PoseStack pose, VertexConsumer consumer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_104207_) {
            Map children = this.f_104213_;
            if (!this.f_104212_.isEmpty() || !children.isEmpty()) {
                pose.m_85836_();
                pose.m_252880_(this.f_104200_ / 16.0f, this.f_104201_ / 16.0f, this.f_104202_ / 16.0f);
                if (this.f_104203_ != 0.0f || this.f_104204_ != 0.0f || this.f_104205_ != 0.0f) {
                    pose.m_252781_(new Quaternionf().rotationZYX(this.f_104205_, this.f_104204_, this.f_104203_));
                }
                if (this.scaleChildren) {
                    pose.m_252880_(this.xOffset, this.yOffset, this.zOffset);
                    pose.m_85841_(this.f_233553_, this.f_233554_, this.f_233555_);
                    this.compile(pose.m_85850_(), consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                } else {
                    pose.m_85836_();
                    pose.m_252880_(this.xOffset, this.yOffset, this.zOffset);
                    pose.m_85841_(this.f_233553_, this.f_233554_, this.f_233555_);
                    this.compile(pose.m_85850_(), consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                    pose.m_85849_();
                }
                for (ModelPart part : children.values()) {
                    part.m_104306_(pose, consumer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                }
                pose.m_85849_();
            }
        }
    }

    private void compile(PoseStack.Pose pose, VertexConsumer consumer, int p_104293_, int p_104294_, float p_104295_, float p_104296_, float p_104297_, float p_104298_) {
        for (ModelPart.Cube cube : this.f_104212_) {
            cube.m_171332_(pose, consumer, p_104293_, p_104294_, p_104295_, p_104296_, p_104297_, p_104298_);
        }
    }

    @Override
    public void addOffset(float x, float y, float z) {
        this.xOffset -= x;
        this.yOffset -= y;
        this.zOffset -= z;
    }

    public void loadPose(EndimatorPartPose endimatorPartPose) {
        this.m_171322_(endimatorPartPose.partPose);
        this.setOffset(endimatorPartPose.offsetX, endimatorPartPose.offsetY, endimatorPartPose.offsetZ);
        this.setScale(endimatorPartPose.scaleX, endimatorPartPose.scaleY, endimatorPartPose.scaleZ);
    }

    public void setInitialPose(EndimatorPartPose endimatorPartPose) {
        this.m_233560_(endimatorPartPose.partPose);
        this.initialPartPose = endimatorPartPose;
    }
}

