/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.obelisk;

import com.enderio.machines.common.blockentity.AversionObeliskBlockEntity;
import com.enderio.machines.common.obelisk.IObeliskManagerCapability;
import com.enderio.machines.common.obelisk.ObeliskManager;
import com.enderio.machines.common.obelisk.ObeliskManagerAttacher;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enderio", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AversionObeliskManager
extends ObeliskManager<AversionObeliskBlockEntity> {
    public static LazyOptional<IObeliskManagerCapability<AversionObeliskBlockEntity>> getManager(ServerLevel serverLevel) {
        return serverLevel.getCapability(ObeliskManagerAttacher.AVERSION_OBELISK_MANAGER_CAPABILITY);
    }

    @SubscribeEvent
    public static void onSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        if (event.getSpawnType() != MobSpawnType.NATURAL) {
            return;
        }
        ServerLevelAccessor levelAccessor = event.getLevel();
        ServerLevel level = levelAccessor.m_6018_();
        AversionObeliskManager.getManager(level).ifPresent(obeliskManager -> {
            AversionObeliskBlockEntity obelisk;
            BlockPos pos = new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ());
            Set obelisks = obeliskManager.getObelisksFor(pos);
            if (obelisks == null || obelisks.isEmpty()) {
                return;
            }
            Iterator iterator = obelisks.iterator();
            while (iterator.hasNext() && !(obelisk = (AversionObeliskBlockEntity)iterator.next()).handleSpawnEvent(event)) {
            }
        });
    }
}

