/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.fluid;

import com.enderio.machines.common.blockentity.base.MachineBlockEntity;
import com.enderio.machines.common.io.fluid.MachineFluidHandler;
import com.enderio.machines.common.io.fluid.MachineFluidTank;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankAccess {
    private int index = Integer.MIN_VALUE;

    public MachineFluidTank getTank(MachineBlockEntity machine) {
        return this.getTank(machine.getFluidHandler());
    }

    public MachineFluidTank getTank(MachineFluidHandler fluidHandler) {
        return fluidHandler.getTank(this.index);
    }

    public int getCapacity(MachineBlockEntity machine) {
        return this.getCapacity(machine.getFluidHandler());
    }

    public int getCapacity(MachineFluidHandler fluidHandler) {
        return fluidHandler.getTankCapacity(this.index);
    }

    public FluidStack getFluid(MachineBlockEntity machine) {
        return this.getFluid(machine.getFluidHandler());
    }

    public FluidStack getFluid(MachineFluidHandler handler) {
        return handler.getFluidInTank(this.index);
    }

    public int getFluidAmount(MachineBlockEntity machine) {
        return this.getFluid(machine).getAmount();
    }

    public int getFluidAmount(MachineFluidHandler handler) {
        return this.getFluid(handler).getAmount();
    }

    public void setFluid(MachineBlockEntity machine, FluidStack fluid) {
        this.setFluid(machine.getFluidHandler(), fluid);
    }

    public void setFluid(MachineFluidHandler handler, FluidStack fluid) {
        handler.setFluidInTank(this.index, fluid);
    }

    public boolean isFluidValid(MachineBlockEntity machine, FluidStack fluid) {
        return this.isFluidValid(machine.getFluidHandler(), fluid);
    }

    public boolean isFluidValid(MachineFluidHandler handler, FluidStack fluid) {
        return handler.isFluidValid(this.index, fluid);
    }

    public boolean isEmpty(MachineBlockEntity machine) {
        return this.isEmpty(machine.getFluidHandler());
    }

    public boolean isEmpty(MachineFluidHandler handler) {
        return this.getFluid(handler).isEmpty();
    }

    public int fill(MachineFluidHandler handler, FluidStack stack, IFluidHandler.FluidAction action) {
        return handler.fill(stack, action);
    }

    public int fill(MachineBlockEntity machine, FluidStack stack, IFluidHandler.FluidAction action) {
        return this.fill(machine.getFluidHandler(), stack, action);
    }

    public FluidStack drain(MachineFluidHandler handler, FluidStack resource, IFluidHandler.FluidAction action) {
        return handler.drain(resource, action);
    }

    public FluidStack drain(MachineBlockEntity machine, FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drain(machine.getFluidHandler(), resource, action);
    }

    public FluidStack drain(MachineFluidHandler handler, int maxDrain, IFluidHandler.FluidAction action) {
        return handler.drain(maxDrain, action);
    }

    public FluidStack drain(MachineBlockEntity machine, int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(machine.getFluidHandler(), maxDrain, action);
    }

    public boolean isTank(int slot) {
        return this.index == slot;
    }

    void init(int i) {
        if (this.index == Integer.MIN_VALUE) {
            this.index = i;
        } else if (this.index != i) {
            throw new IllegalArgumentException("TankLayout changed dynamically from " + this.index + " to " + i + ", don't do that");
        }
    }
}

