/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.redstone;

import com.enderio.api.filter.ResourceFilter;
import com.enderio.base.common.init.EIOCapabilities;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneFilterItem
extends Item {
    @Nullable
    private final Supplier<MenuType<?>> menu;
    private final Function<ItemStack, ResourceFilter> filterFactory;

    public RedstoneFilterItem(Item.Properties pProperties, Function<ItemStack, ResourceFilter> filterFactory, @Nullable Supplier<MenuType<?>> menu) {
        super(pProperties);
        this.menu = menu;
        this.filterFactory = filterFactory;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction direction) {
                if (capability == EIOCapabilities.FILTER) {
                    return LazyOptional.of(() -> RedstoneFilterItem.this.filterFactory.apply(stack)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (this.menu != null) {
                this.openMenu(serverPlayer);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    private void openMenu(ServerPlayer player) {
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"");
            }

            public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
                return RedstoneFilterItem.this.menu.get().m_39985_(pContainerId, pInventory);
            }
        });
    }
}

